/// <reference path="./internal_*.d.ts" />
declare namespace slimeknights.tconstruct.library.recipe.partbuilder {
    class Pattern extends ResourceLocation {
        constructor(resourceLocation: ResourceLocation_)
        constructor(namespaceIn: string, pathIn: string)
        constructor(resourceName: string)
        getDisplayName(): net.minecraft.network.chat.Component;
        static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        getTexture(): ResourceLocation;
        static tryCreate(string: string): Internal.ModifierId;
        get displayName(): net.minecraft.network.chat.Component
        get texture(): ResourceLocation
        static readonly SERIALIZER: Internal.Pattern$Serializer;
    }
    type Pattern_ = Pattern;
}
declare namespace dev.emi.emi.mixin.accessor {
    interface HandledScreenAccessor {
        abstract getFocusedSlot(): Internal.Slot;
        abstract getBackgroundWidth(): number;
        abstract invokeGetSlotAt(arg0: number, arg1: number): Internal.Slot;
        abstract getX(): number;
        abstract getY(): number;
        abstract getBackgroundHeight(): number;
        get focusedSlot(): Internal.Slot
        get backgroundWidth(): number
        get x(): number
        get y(): number
        get backgroundHeight(): number
    }
    type HandledScreenAccessor_ = HandledScreenAccessor;
}
declare namespace Internal {
    interface ChangeOverTimeBlock <T extends Internal.Enum<T>> {
        applyChangeOverTime($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        abstract getNext(arg0: Internal.BlockState_): Internal.Optional<Internal.BlockState>;
        onRandomTick($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        abstract getAge(): T;
        abstract getChanceModifier(): number;
        get age(): T
        get chanceModifier(): number
        readonly SCAN_DISTANCE: 4;
    }
    type ChangeOverTimeBlock_<T extends Internal.Enum<T>> = ChangeOverTimeBlock<T>;
    interface Hash {
        /**
         * @deprecated
        */
        readonly PRIMES: number[];
        readonly DEFAULT_LOAD_FACTOR: 0.75;
        /**
         * @deprecated
        */
        readonly FREE: 0;
        readonly VERY_FAST_LOAD_FACTOR: 0.25;
        /**
         * @deprecated
        */
        readonly DEFAULT_GROWTH_FACTOR: 16;
        readonly FAST_LOAD_FACTOR: 0.5;
        /**
         * @deprecated
        */
        readonly OCCUPIED: -1;
        /**
         * @deprecated
        */
        readonly REMOVED: 1;
        readonly DEFAULT_INITIAL_SIZE: 16;
    }
    type Hash_ = Hash;
    class FleshBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type FleshBlock_ = FleshBlock;
    class Toast$Visibility extends Internal.Enum<Internal.Toast$Visibility> {
        playSound($$0: Internal.SoundManager_): void;
        static values(): Internal.Toast$Visibility[];
        static valueOf($$0: string): Internal.Toast$Visibility;
        static readonly HIDE: Internal.Toast$Visibility;
        static readonly SHOW: Internal.Toast$Visibility;
    }
    type Toast$Visibility_ = "hide" | "show" | Toast$Visibility;
    class ClientPacketListener implements Internal.ClientGamePacketListener, Internal.NetworkHandlerExtensions, Internal.TickablePacketListener, Internal.ClientPacketListenerAccessor {
        constructor($$0: Internal.Minecraft_, $$1: Internal.Screen_, $$2: Internal.Connection_, $$3: Internal.ServerData_, $$4: Internal.GameProfile_, $$5: Internal.WorldSessionTelemetryManager_)
        setActionBarText($$0: Internal.ClientboundSetActionBarTextPacket_): void;
        handleContainerSetSlot($$0: Internal.ClientboundContainerSetSlotPacket_): void;
        handleAddPlayer($$0: Internal.ClientboundAddPlayerPacket_): void;
        handleSetScore($$0: Internal.ClientboundSetScorePacket_): void;
        handleAnimate($$0: Internal.ClientboundAnimatePacket_): void;
        handlePlayerInfoRemove($$0: Internal.ClientboundPlayerInfoRemovePacket_): void;
        handleResourcePack($$0: Internal.ClientboundResourcePackPacket_): void;
        handleContainerContent($$0: Internal.ClientboundContainerSetContentPacket_): void;
        handleOpenScreen($$0: Internal.ClientboundOpenScreenPacket_): void;
        handleLogin($$0: Internal.ClientboundLoginPacket_): void;
        handleTagQueryPacket($$0: Internal.ClientboundTagQueryPacket_): void;
        port_lib$getServerChunkRadius(): number;
        getConnection(): Internal.Connection;
        getPlayerInfo($$0: string): Internal.PlayerInfo;
        onDisconnect($$0: net.minecraft.network.chat.Component_): void;
        handleUpdateAttributes($$0: Internal.ClientboundUpdateAttributesPacket_): void;
        handleSetSpawn($$0: Internal.ClientboundSetDefaultSpawnPositionPacket_): void;
        handleCustomPayload($$0: Internal.ClientboundCustomPayloadPacket_): void;
        handleLookAt($$0: Internal.ClientboundPlayerLookAtPacket_): void;
        handlePlayerInfoUpdate($$0: Internal.ClientboundPlayerInfoUpdatePacket_): void;
        handleParticleEvent($$0: Internal.ClientboundLevelParticlesPacket_): void;
        sendChat($$0: string): void;
        levels(): Internal.Set<Internal.ResourceKey<Internal.Level>>;
        getCommands(): Internal.CommandDispatcher<Internal.SharedSuggestionProvider>;
        handleHurtAnimation($$0: Internal.ClientboundHurtAnimationPacket_): void;
        modify$bje000$chat_heads$chatheads$rememberSenderInfo(playerChatMessage: Internal.PlayerChatMessage_, senderInfo: Internal.LocalRef_<any>): Internal.PlayerChatMessage;
        handleTitlesClear($$0: Internal.ClientboundClearTitlesPacket_): void;
        handleCustomChatCompletions($$0: Internal.ClientboundCustomChatCompletionsPacket_): void;
        sendUnsignedCommand($$0: string): boolean;
        handleContainerClose($$0: Internal.ClientboundContainerClosePacket_): void;
        handleRemoveEntities($$0: Internal.ClientboundRemoveEntitiesPacket_): void;
        handleSetCamera($$0: Internal.ClientboundSetCameraPacket_): void;
        handlePlayerCombatEnter($$0: Internal.ClientboundPlayerCombatEnterPacket_): void;
        handleTeleportEntity($$0: Internal.ClientboundTeleportEntityPacket_): void;
        handleForgetLevelChunk($$0: Internal.ClientboundForgetLevelChunkPacket_): void;
        handler$cpn000$ftbchunks$handleLevelChunkFTBC(packet: Internal.ClientboundLevelChunkWithLightPacket_, ci: Internal.CallbackInfo_): void;
        handleBlockEvent($$0: Internal.ClientboundBlockEventPacket_): void;
        handler$zem000$porting_lib_base$port_lib$handleCustomBlockEntity(packet: Internal.ClientboundBlockEntityDataPacket_, blockEntity: Internal.BlockEntity_, ci: Internal.CallbackInfo_): void;
        handleLightUpdatePacket($$0: Internal.ClientboundLightUpdatePacket_): void;
        handler$cpn000$ftbchunks$handleChunkBlocksUpdateFTBC(packet: Internal.ClientboundSectionBlocksUpdatePacket_, ci: Internal.CallbackInfo_): void;
        handleMoveVehicle($$0: Internal.ClientboundMoveVehiclePacket_): void;
        handleCommands($$0: Internal.ClientboundCommandsPacket_): void;
        handleSetBorderCenter($$0: Internal.ClientboundSetBorderCenterPacket_): void;
        getOnlinePlayers(): Internal.Collection<Internal.PlayerInfo>;
        handleItemCooldown($$0: Internal.ClientboundCooldownPacket_): void;
        handleAddExperienceOrb($$0: Internal.ClientboundAddExperienceOrbPacket_): void;
        setSubtitleText($$0: Internal.ClientboundSetSubtitleTextPacket_): void;
        handleRespawn($$0: Internal.ClientboundRespawnPacket_): void;
        getLevel(): Internal.ClientLevel;
        handleCommandSuggestions($$0: Internal.ClientboundCommandSuggestionsPacket_): void;
        setKeyPair($$0: Internal.ProfileKeyPair_): void;
        handleSetEquipment($$0: Internal.ClientboundSetEquipmentPacket_): void;
        handleChunkBlocksUpdate($$0: Internal.ClientboundSectionBlocksUpdatePacket_): void;
        handleBlockChangedAck($$0: Internal.ClientboundBlockChangedAckPacket_): void;
        isFeatureEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getOnlinePlayerIds(): Internal.Collection<Internal.UUID>;
        handleExplosion($$0: Internal.ClientboundExplodePacket_): void;
        handleUpdateMobEffect($$0: Internal.ClientboundUpdateMobEffectPacket_): void;
        handleKeepAlive($$0: Internal.ClientboundKeepAlivePacket_): void;
        handleUpdateRecipes($$0: Internal.ClientboundUpdateRecipesPacket_): void;
        handleLevelChunkWithLight($$0: Internal.ClientboundLevelChunkWithLightPacket_): void;
        handleOpenBook($$0: Internal.ClientboundOpenBookPacket_): void;
        handleBlockEntityData($$0: Internal.ClientboundBlockEntityDataPacket_): void;
        handleUpdateAdvancementsPacket($$0: Internal.ClientboundUpdateAdvancementsPacket_): void;
        handleBundlePacket($$0: Internal.ClientboundBundlePacket_): void;
        handleSetChunkCacheRadius($$0: Internal.ClientboundSetChunkCacheRadiusPacket_): void;
        handleMapItemData($$0: Internal.ClientboundMapItemDataPacket_): void;
        handleInitializeBorder($$0: Internal.ClientboundInitializeBorderPacket_): void;
        getAdvancements(): Internal.ClientAdvancements;
        handleSetPlayerTeamPacket($$0: Internal.ClientboundSetPlayerTeamPacket_): void;
        handleBlockDestruction($$0: Internal.ClientboundBlockDestructionPacket_): void;
        handleTakeItemEntity($$0: Internal.ClientboundTakeItemEntityPacket_): void;
        handleServerData($$0: Internal.ClientboundServerDataPacket_): void;
        handleEntityLinkPacket($$0: Internal.ClientboundSetEntityLinkPacket_): void;
        getServerData(): Internal.ServerData;
        handlePlayerChat($$0: Internal.ClientboundPlayerChatPacket_): void;
        handleSetBorderSize($$0: Internal.ClientboundSetBorderSizePacket_): void;
        handleSetTime($$0: Internal.ClientboundSetTimePacket_): void;
        handleSetCarriedItem($$0: Internal.ClientboundSetCarriedItemPacket_): void;
        setTitlesAnimation($$0: Internal.ClientboundSetTitlesAnimationPacket_): void;
        handleDamageEvent($$0: Internal.ClientboundDamageEventPacket_): void;
        handleSetBorderLerpSize($$0: Internal.ClientboundSetBorderLerpSizePacket_): void;
        handleSetExperience($$0: Internal.ClientboundSetExperiencePacket_): void;
        markMessageAsProcessed($$0: Internal.PlayerChatMessage_, $$1: boolean): void;
        handleSetDisplayObjective($$0: Internal.ClientboundSetDisplayObjectivePacket_): void;
        handler$fdn000$moonlight$afterLoad(clientboundBlockEntityDataPacket: Internal.ClientboundBlockEntityDataPacket_, blockEntity: Internal.BlockEntity_, ci: Internal.CallbackInfo_): void;
        handler$zem000$porting_lib_base$port_lib$updateTags(packet: Internal.ClientboundUpdateTagsPacket_, ci: Internal.CallbackInfo_): void;
        handleChunksBiomes($$0: Internal.ClientboundChunksBiomesPacket_): void;
        enabledFeatures(): Internal.FeatureFlagSet;
        handleDisconnect($$0: Internal.ClientboundDisconnectPacket_): void;
        handleSetHealth($$0: Internal.ClientboundSetHealthPacket_): void;
        handleTabListCustomisation($$0: Internal.ClientboundTabListPacket_): void;
        handleAddObjective($$0: Internal.ClientboundSetObjectivePacket_): void;
        handleUpdateTags($$0: Internal.ClientboundUpdateTagsPacket_): void;
        handleMerchantOffers($$0: Internal.ClientboundMerchantOffersPacket_): void;
        handleStopSoundEvent($$0: Internal.ClientboundStopSoundPacket_): void;
        handler$fdn000$moonlight$beforeLoad(clientboundBlockEntityDataPacket: Internal.ClientboundBlockEntityDataPacket_, blockEntity: Internal.BlockEntity_, ci: Internal.CallbackInfo_): void;
        tick(): void;
        handleRemoveMobEffect($$0: Internal.ClientboundRemoveMobEffectPacket_): void;
        handleSetSimulationDistance($$0: Internal.ClientboundSetSimulationDistancePacket_): void;
        handleSetChunkCacheCenter($$0: Internal.ClientboundSetChunkCacheCenterPacket_): void;
        handler$zem000$porting_lib_base$port_lib$updateRecipes(packet: Internal.ClientboundUpdateRecipesPacket_, ci: Internal.CallbackInfo_): void;
        getAddon(): Internal.AbstractNetworkAddon<any>;
        sendCommand($$0: string): void;
        getId(): Internal.UUID;
        handleDisguisedChat($$0: Internal.ClientboundDisguisedChatPacket_): void;
        handlePing($$0: Internal.ClientboundPingPacket_): void;
        handleBlockUpdate($$0: Internal.ClientboundBlockUpdatePacket_): void;
        handler$cpn000$ftbchunks$handleBlockUpdateFTBC(packet: Internal.ClientboundBlockUpdatePacket_, ci: Internal.CallbackInfo_): void;
        handleRotateMob($$0: Internal.ClientboundRotateHeadPacket_): void;
        handleSystemChat($$0: Internal.ClientboundSystemChatPacket_): void;
        handleMovePlayer($$0: Internal.ClientboundPlayerPositionPacket_): void;
        handleDeleteChat($$0: Internal.ClientboundDeleteChatPacket_): void;
        handleAddEntity($$0: Internal.ClientboundAddEntityPacket_): void;
        handleSoundEntityEvent($$0: Internal.ClientboundSoundEntityPacket_): void;
        handleHorseScreenOpen($$0: Internal.ClientboundHorseScreenOpenPacket_): void;
        handleChangeDifficulty($$0: Internal.ClientboundChangeDifficultyPacket_): void;
        handleSetBorderWarningDelay($$0: Internal.ClientboundSetBorderWarningDelayPacket_): void;
        handleEntityEvent($$0: Internal.ClientboundEntityEventPacket_): void;
        handler$bje000$chat_heads$chatheads$captureSenderInfo(packet: Internal.ClientboundPlayerChatPacket_, ci: Internal.CallbackInfo_, senderInfo: Internal.LocalRef_<any>): void;
        handleEnabledFeatures($$0: Internal.ClientboundUpdateEnabledFeaturesPacket_): void;
        getListedOnlinePlayers(): Internal.Collection<Internal.PlayerInfo>;
        handleOpenSignEditor($$0: Internal.ClientboundOpenSignEditorPacket_): void;
        setTitleText($$0: Internal.ClientboundSetTitleTextPacket_): void;
        handleSetEntityData($$0: Internal.ClientboundSetEntityDataPacket_): void;
        getDebugQueryHandler(): Internal.DebugQueryHandler;
        handleBossUpdate($$0: Internal.ClientboundBossEventPacket_): void;
        handlePlaceRecipe($$0: Internal.ClientboundPlaceGhostRecipePacket_): void;
        getSuggestionsProvider(): Internal.ClientSuggestionProvider;
        getLocalGameProfile(): Internal.GameProfile;
        getPlayerInfo($$0: Internal.UUID_): Internal.PlayerInfo;
        handleGameEvent($$0: Internal.ClientboundGameEventPacket_): void;
        isAcceptingMessages(): boolean;
        handleSoundEvent($$0: Internal.ClientboundSoundPacket_): void;
        handleSetEntityMotion($$0: Internal.ClientboundSetEntityMotionPacket_): void;
        handleContainerSetData($$0: Internal.ClientboundContainerSetDataPacket_): void;
        handlePlayerCombatEnd($$0: Internal.ClientboundPlayerCombatEndPacket_): void;
        handleMoveEntity($$0: Internal.ClientboundMoveEntityPacket_): void;
        registryAccess(): Internal.RegistryAccess;
        handleLevelEvent($$0: Internal.ClientboundLevelEventPacket_): void;
        handlePlayerAbilities($$0: Internal.ClientboundPlayerAbilitiesPacket_): void;
        shouldPropagateHandlingExceptions(): boolean;
        handlePlayerCombatKill($$0: Internal.ClientboundPlayerCombatKillPacket_): void;
        handleSetBorderWarningDistance($$0: Internal.ClientboundSetBorderWarningDistancePacket_): void;
        getRecipeManager(): Internal.RecipeManager;
        handleAwardStats($$0: Internal.ClientboundAwardStatsPacket_): void;
        handleSetEntityPassengersPacket($$0: Internal.ClientboundSetPassengersPacket_): void;
        close(): void;
        handleSelectAdvancementsTab($$0: Internal.ClientboundSelectAdvancementsTabPacket_): void;
        send($$0: Internal.Packet_<any>): void;
        handleAddOrRemoveRecipes($$0: Internal.ClientboundRecipePacket_): void;
        set actionBarText($$0: Internal.ClientboundSetActionBarTextPacket_)
        get connection(): Internal.Connection
        get commands(): Internal.CommandDispatcher<Internal.SharedSuggestionProvider>
        get onlinePlayers(): Internal.Collection<Internal.PlayerInfo>
        set subtitleText($$0: Internal.ClientboundSetSubtitleTextPacket_)
        get level(): Internal.ClientLevel
        set keyPair($$0: Internal.ProfileKeyPair_)
        get onlinePlayerIds(): Internal.Collection<Internal.UUID>
        get advancements(): Internal.ClientAdvancements
        get serverData(): Internal.ServerData
        set titlesAnimation($$0: Internal.ClientboundSetTitlesAnimationPacket_)
        get addon(): Internal.AbstractNetworkAddon<any>
        get id(): Internal.UUID
        get listedOnlinePlayers(): Internal.Collection<Internal.PlayerInfo>
        set titleText($$0: Internal.ClientboundSetTitleTextPacket_)
        get debugQueryHandler(): Internal.DebugQueryHandler
        get suggestionsProvider(): Internal.ClientSuggestionProvider
        get localGameProfile(): Internal.GameProfile
        get acceptingMessages(): boolean
        get recipeManager(): Internal.RecipeManager
        serverChunkRadius: number;
    }
    type ClientPacketListener_ = ClientPacketListener;
    abstract class AbstractObjectCollection <K> extends Internal.AbstractCollection<K> implements Internal.ObjectCollection<K> {
        parallelStream(): Internal.Stream<K>;
        abstract iterator(): Internal.ObjectIterator<K>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        forEach(arg0: Internal.Consumer_<K>): void;
        spliterator(): Internal.ObjectSpliterator<K>;
        removeIf(arg0: Internal.Predicate_<K>): boolean;
        stream(): Internal.Stream<K>;
    }
    type AbstractObjectCollection_<K> = AbstractObjectCollection<K>;
    interface LootTableBuilderExtensions {
        abstract port_lib$setId(arg0: ResourceLocation_): void;
        (arg0: ResourceLocation): void;
    }
    type LootTableBuilderExtensions_ = LootTableBuilderExtensions;
    interface Byte2DoubleFunction extends Internal.IntToDoubleFunction, it.unimi.dsi.fastutil.Function<number, number> {
        /**
         * @deprecated
        */
        applyAsDouble(arg0: number): number;
        composeReference<T>(arg0: Internal.Reference2ByteFunction_<T>): Internal.Reference2DoubleFunction<T>;
        getOrDefault(arg0: number, arg1: number): number;
        andThenChar(arg0: Internal.Double2CharFunction_): Internal.Byte2CharFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        andThenShort(arg0: Internal.Double2ShortFunction_): Internal.Byte2ShortFunction;
        apply(arg0: number): number;
        remove(arg0: number): number;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        abstract get(arg0: number): number;
        composeChar(arg0: Internal.Char2ByteFunction_): Internal.Char2DoubleFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenLong(arg0: Internal.Double2LongFunction_): Internal.Byte2LongFunction;
        composeObject<T>(arg0: Internal.Object2ByteFunction_<T>): Internal.Object2DoubleFunction<T>;
        andThenByte(arg0: Internal.Double2ByteFunction_): Internal.Byte2ByteFunction;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        andThenObject<T>(arg0: Internal.Double2ObjectFunction_<T>): Internal.Byte2ObjectFunction<T>;
        composeInt(arg0: Internal.Int2ByteFunction_): Internal.Int2DoubleFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        containsKey(arg0: number): boolean;
        defaultReturnValue(arg0: number): void;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeByte(arg0: Internal.Byte2ByteFunction_): this;
        composeDouble(arg0: Internal.Double2ByteFunction_): Internal.Double2DoubleFunction;
        composeShort(arg0: Internal.Short2ByteFunction_): Internal.Short2DoubleFunction;
        defaultReturnValue(): number;
        size(): number;
        andThenInt(arg0: Internal.Double2IntFunction_): Internal.Byte2IntFunction;
        andThenFloat(arg0: Internal.Double2FloatFunction_): Internal.Byte2FloatFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        clear(): void;
        put(arg0: number, arg1: number): number;
        composeLong(arg0: Internal.Long2ByteFunction_): Internal.Long2DoubleFunction;
        andThenReference<T>(arg0: Internal.Double2ReferenceFunction_<T>): Internal.Byte2ReferenceFunction<T>;
        composeFloat(arg0: Internal.Float2ByteFunction_): Internal.Float2DoubleFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        andThenDouble(arg0: Internal.Double2DoubleFunction_): this;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        (arg0: number): number;
    }
    type Byte2DoubleFunction_ = Byte2DoubleFunction;
    class HexCoord {
        constructor(q: number, r: number)
        component2(): number;
        component1(): number;
        getR(): number;
        minus(x: Internal.HexCoord_): this;
        static copy$default(arg0: Internal.HexCoord_, arg1: number, arg2: number, arg3: number, arg4: any): Internal.HexCoord;
        getQ(): number;
        rangeAround(radius: number): Internal.Iterator<Internal.HexCoord>;
        delta(x: Internal.HexCoord_): this;
        immediateDelta(neighbor: Internal.HexCoord_): Internal.HexDir;
        copy(q: number, r: number): this;
        plus(x: Internal.HexCoord_): this;
        static getOrigin(): Internal.HexCoord;
        plus(d: Internal.HexDir_): this;
        shiftedBy(d: Internal.HexDir_): this;
        s(): number;
        shiftedBy(x: Internal.HexCoord_): this;
        static access$getOrigin$cp(): Internal.HexCoord;
        distanceTo(x: Internal.HexCoord_): number;
        get r(): number
        get q(): number
        get origin(): Internal.HexCoord
        static readonly Companion: Internal.HexCoord$Companion;
    }
    type HexCoord_ = HexCoord;
    class BunnyHoppersItem extends Internal.MobEffectItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static shouldCancelFallDamage(entity: Internal.LivingEntity_): boolean;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        hasNonCosmeticEffects(): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BunnyHoppersItem_ = BunnyHoppersItem;
    class Ticker {
        constructor(max: number)
        back(): void;
        getTicks(): number;
        setAll(ticks: number): void;
        onward(): void;
        ended(): boolean;
        isEmpty(): boolean;
        setTicks(ticks: number): void;
        perCent(): number;
        write(compound: Internal.CompoundTag_, key: string): void;
        setMax(max: number): void;
        add(ticks: number): void;
        static empty(): Internal.Ticker;
        reset(): void;
        back(value: number): void;
        subSized(): number;
        getEmpty(): number;
        read(compound: Internal.CompoundTag_, key: string): void;
        getMax(): number;
        static delayed(delay: number): boolean;
        get ticks(): number
        set all(ticks: number)
        get empty(): boolean
        set ticks(ticks: number)
        set max(max: number)
        get empty(): number
        get max(): number
    }
    type Ticker_ = Ticker;
    interface EnchantmentBuilder$DamageBonusFunction {
        abstract getDamageBonus(arg0: number, arg1: string): number;
        (arg0: number, arg1: string): number;
    }
    type EnchantmentBuilder$DamageBonusFunction_ = EnchantmentBuilder$DamageBonusFunction;
    class Clear implements Internal.RuleBlockEntityModifier {
        constructor()
        getType(): Internal.RuleBlockEntityModifierType<any>;
        apply($$0: Internal.RandomSource_, $$1: Internal.CompoundTag_): Internal.CompoundTag;
        get type(): Internal.RuleBlockEntityModifierType<any>
        static readonly CODEC: Internal.Codec<Internal.Clear>;
    }
    type Clear_ = Clear;
    class PropertyChangeEvent extends Internal.EventObject {
        constructor(arg0: any, arg1: string, arg2: any, arg3: any)
        setPropagationId(arg0: any): void;
        getPropertyName(): string;
        getPropagationId(): any;
        getNewValue(): any;
        getOldValue(): any;
        set propagationId(arg0: any)
        get propertyName(): string
        get propagationId(): any
        get newValue(): any
        get oldValue(): any
    }
    type PropertyChangeEvent_ = PropertyChangeEvent;
    class ItemStymphalianDagger extends Internal.SwordItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemStymphalianDagger_ = ItemStymphalianDagger;
    interface Reference2ObjectFunction <K, V> extends it.unimi.dsi.fastutil.Function<K, V> {
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<K, V>;
        getOrDefault(arg0: any, arg1: V): V;
        composeByte(arg0: Internal.Byte2ReferenceFunction_<K>): Internal.Byte2ObjectFunction<V>;
        composeInt(arg0: Internal.Int2ReferenceFunction_<K>): Internal.Int2ObjectFunction<V>;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Reference2DoubleFunction<K>;
        composeDouble(arg0: Internal.Double2ReferenceFunction_<K>): Internal.Double2ObjectFunction<V>;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Reference2FloatFunction<K>;
        containsKey(arg0: any): boolean;
        put(arg0: K, arg1: V): V;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Reference2LongFunction<K>;
        composeObject<T>(arg0: Internal.Object2ReferenceFunction_<T, K>): Internal.Object2ObjectFunction<T, V>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Reference2ByteFunction<K>;
        composeShort(arg0: Internal.Short2ReferenceFunction_<K>): Internal.Short2ObjectFunction<V>;
        abstract get(arg0: any): V;
        remove(arg0: any): V;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Reference2ShortFunction<K>;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Reference2ReferenceFunction<K, T>;
        apply(arg0: K): V;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Reference2CharFunction<K>;
        composeLong(arg0: Internal.Long2ReferenceFunction_<K>): Internal.Long2ObjectFunction<V>;
        composeFloat(arg0: Internal.Float2ReferenceFunction_<K>): Internal.Float2ObjectFunction<V>;
        size(): number;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, V>;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Reference2ObjectFunction<K, T>;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Reference2IntFunction<K>;
        composeReference<T>(arg0: Internal.Reference2ReferenceFunction_<T, K>): Internal.Reference2ObjectFunction<T, V>;
        clear(): void;
        composeChar(arg0: Internal.Char2ReferenceFunction_<K>): Internal.Char2ObjectFunction<V>;
        defaultReturnValue(): V;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        (arg0: any): V;
    }
    type Reference2ObjectFunction_<K, V> = Reference2ObjectFunction<K, V>;
    class ModelLayerLocation {
        constructor($$0: ResourceLocation_, $$1: string)
        getModel(): ResourceLocation;
        getLayer(): string;
        get model(): ResourceLocation
        get layer(): string
    }
    type ModelLayerLocation_ = ModelLayerLocation;
    interface FocusLost {
        abstract onFocusLost(): void;
        newStream(): Internal.EventStream<Internal.FocusLost>;
        (): void;
    }
    type FocusLost_ = FocusLost;
    interface WatchService extends Internal.Closeable {
        abstract poll(): Internal.WatchKey;
        abstract close(): void;
        abstract take(): Internal.WatchKey;
        abstract poll(arg0: number, arg1: Internal.TimeUnit_): Internal.WatchKey;
    }
    type WatchService_ = WatchService;
    interface ClassDesc extends Internal.TypeDescriptor$OfField<Internal.ClassDesc>, Internal.ConstantDesc {
        componentType(): Internal.TypeDescriptor$OfField<any>;
        isPrimitive(): boolean;
        displayName(): string;
        ofDescriptor(arg0: string): this;
        of(arg0: string): this;
        abstract descriptorString(): string;
        resolveConstantDesc(arg0: Internal.MethodHandles$Lookup_): any;
        nested(arg0: string, ...arg1: string[]): this;
        of(arg0: string, arg1: string): this;
        isArray(): boolean;
        nested(arg0: string): this;
        isClassOrInterface(): boolean;
        packageName(): string;
        abstract equals(arg0: any): boolean;
        ofInternalName(arg0: string): this;
        arrayType(arg0: number): this;
        arrayType(): Internal.TypeDescriptor$OfField<any>;
        get primitive(): boolean
        get array(): boolean
        get classOrInterface(): boolean
    }
    type ClassDesc_ = ClassDesc;
    class NamespacedNBT implements Internal.INamespacedNBTView {
        constructor()
        getBoolean(name: ResourceLocation_): boolean;
        getCopy(): Internal.CompoundTag;
        static readFromNBT(data: Internal.CompoundTag_): Internal.NamespacedNBT;
        putLong(name: ResourceLocation_, value: number): void;
        get(name: ResourceLocation_): Internal.Tag;
        getInt(name: ResourceLocation_): number;
        putString(name: ResourceLocation_, value: string): void;
        getCompound(name: ResourceLocation_): Internal.CompoundTag;
        put(name: ResourceLocation_, nbt: Internal.Tag_): void;
        contains(name: ResourceLocation_, type: number): boolean;
        getFloat(name: ResourceLocation_): number;
        readFromNbt(compoundTag: Internal.CompoundTag_): void;
        putFloat(name: ResourceLocation_, value: number): void;
        getString(name: ResourceLocation_): string;
        remove(name: ResourceLocation_): void;
        writeToNbt(compoundTag: Internal.CompoundTag_): void;
        copyFrom(data: Internal.CompoundTag_): void;
        shouldCopyForRespawn(lossless: boolean, keepInventory: boolean, sameCharacter: boolean): boolean;
        putInt(name: ResourceLocation_, value: number): void;
        copyFrom(other: Internal.INamespacedNBTView_): void;
        copyForRespawn(original: Internal.INamespacedNBTView_, lossless: boolean, keepInventory: boolean, sameCharacter: boolean): void;
        get<T>(name: ResourceLocation_, function_: Internal.BiFunction_<Internal.CompoundTag, string, T>): T;
        putBoolean(name: ResourceLocation_, value: boolean): void;
        get copy(): Internal.CompoundTag
    }
    type NamespacedNBT_ = NamespacedNBT;
    abstract class AbstractSchoolingFish extends Internal.AbstractFish {
        constructor($$0: Internal.EntityType_<Internal.AbstractSchoolingFish>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getMaxSchoolSize(): number;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        /**
         * @deprecated
        */
        static loadDefaultDataFromBucketTag($$0: Internal.Mob_, $$1: Internal.CompoundTag_): void;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        isFollower(): boolean;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        pathToLeader(): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        canBeFollowed(): boolean;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        addFollowers($$0: Internal.Stream_<Internal.AbstractSchoolingFish>): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        stopFollowing(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        /**
         * @deprecated
        */
        static saveDefaultDataToBucketTag($$0: Internal.Mob_, $$1: Internal.ItemStack_): void;
        getScriptType(): Internal.ScriptType;
        static bucketMobPickup<T extends Internal.LivingEntity & Internal.Bucketable>($$0: Internal.Player_, $$1: Internal.InteractionHand_, $$2: T): Internal.Optional<Internal.InteractionResult>;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        inRangeOfLeader(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        hasFollowers(): boolean;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        startFollowing($$0: Internal.AbstractSchoolingFish_): this;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get maxSchoolSize(): number
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get follower(): boolean
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type AbstractSchoolingFish_ = AbstractSchoolingFish;
    interface AccessBlockModelRenderer {
        abstract indium$getQuadDimensions(arg0: Internal.BlockAndTintGetter_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: number[], arg4: Internal.Direction_, arg5: number[], arg6: Internal.BitSet_): void;
        (arg0: Internal.BlockAndTintGetter, arg1: Internal.BlockState, arg2: BlockPos, arg3: number[], arg4: Internal.Direction, arg5: number[], arg6: Internal.BitSet): void;
    }
    type AccessBlockModelRenderer_ = AccessBlockModelRenderer;
    class MoltenNetheriteFluid$Source extends Internal.MoltenNetheriteFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenNetheriteFluid$Source_ = MoltenNetheriteFluid$Source;
    class IUpgradeItem$UpgradeConflictDefinition extends Internal.Record {
        constructor(isConflictingItem: Internal.Predicate_<Internal.Item>, maxConflictingAllowed: number, errorMessage: net.minecraft.network.chat.Component_, otherBeingAddedErrorMessage: net.minecraft.network.chat.Component_)
        constructor(isConflictingItem: Internal.Predicate_<Internal.Item>, maxConflictingAllowed: number, errorMessage: net.minecraft.network.chat.Component_)
        maxConflictingAllowed(): number;
        otherBeingAddedErrorMessage(): net.minecraft.network.chat.Component;
        errorMessage(): net.minecraft.network.chat.Component;
        isConflictingItem(): Internal.Predicate<Internal.Item>;
    }
    type IUpgradeItem$UpgradeConflictDefinition_ = IUpgradeItem$UpgradeConflictDefinition;
    class ItemPartRecipe implements Internal.IDisplayPartBuilderRecipe {
        constructor(id: ResourceLocation_, material: Internal.MaterialVariantId_, pattern: slimeknights.tconstruct.library.recipe.partbuilder.Pattern_, patternItem: Internal.Ingredient_, cost: number, result: any_)
        getItemsUsed(inv: Internal.IPartBuilderContainer_): number;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        getMaterial(): Internal.MaterialVariant;
        getPatterns(inv: Internal.IPartBuilderContainer_): Internal.Stream<slimeknights.tconstruct.library.recipe.partbuilder.Pattern>;
        /**
         * @deprecated
        */
        getLeftover(inventoryWrapper: Internal.PartBuilderContainerWrapper_): Internal.ItemStack;
        partialMatch(inv: Internal.IPartBuilderContainer_): boolean;
        getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        getCost(): number;
        getLeftover(inventoryWrapper: Internal.PartBuilderContainerWrapper_, pattern: slimeknights.tconstruct.library.recipe.partbuilder.Pattern_): Internal.ItemStack;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        matches(inv: Internal.IPartBuilderContainer_, worldIn: Internal.Level_): boolean;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getPattern(): slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        assemble(inv: Internal.IPartBuilderContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        assemble(inv: Internal.IPartBuilderContainer_, pattern: slimeknights.tconstruct.library.recipe.partbuilder.Pattern_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getType(): ResourceLocation;
        getPatternItems(): Internal.List<Internal.ItemStack>;
        setGroup(group: string): void;
        getRemainingItems($$0: Internal.IPartBuilderContainer_): Internal.NonNullList<Internal.ItemStack>;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        getTitle(): net.minecraft.network.chat.Component;
        getText(inv: Internal.IPartBuilderContainer_): Internal.List<net.minecraft.network.chat.Component>;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get material(): Internal.MaterialVariant
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get cost(): number
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get pattern(): slimeknights.tconstruct.library.recipe.partbuilder.Pattern
        get special(): boolean
        get type(): ResourceLocation
        get patternItems(): Internal.List<Internal.ItemStack>
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get title(): net.minecraft.network.chat.Component
    }
    type ItemPartRecipe_ = ItemPartRecipe;
    class ItemSummoningCrystal extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        summonEntity(entity: Internal.Entity_, worldIn: Internal.Level_, offsetPos: BlockPos_, yaw: number): void;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onItemUseFinish(worldIn: Internal.Level_, LivingEntity: Internal.LivingEntity_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static hasDragon(stack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemSummoningCrystal_ = ItemSummoningCrystal;
    interface GatheringByteChannel extends Internal.WritableByteChannel {
        abstract write(arg0: Internal.ByteBuffer_): number;
        abstract write(arg0: Internal.ByteBuffer_[], arg1: number, arg2: number): number;
        abstract isOpen(): boolean;
        abstract close(): void;
        abstract write(arg0: Internal.ByteBuffer_[]): number;
        get open(): boolean
    }
    type GatheringByteChannel_ = GatheringByteChannel;
    interface MultifaceSpreader$SpreadPredicate {
        abstract test(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.MultifaceSpreader$SpreadPos_): boolean;
        (arg0: Internal.BlockGetter, arg1: BlockPos, arg2: Internal.MultifaceSpreader$SpreadPos): boolean;
    }
    type MultifaceSpreader$SpreadPredicate_ = MultifaceSpreader$SpreadPredicate;
    class ClientboundLevelChunkPacketData {
        constructor($$0: Internal.FriendlyByteBuf_, $$1: number, $$2: number)
        constructor($$0: Internal.LevelChunk_)
        write($$0: Internal.FriendlyByteBuf_): void;
        getHeightmaps(): Internal.CompoundTag;
        getReadBuffer(): Internal.FriendlyByteBuf;
        static extractChunkData($$0: Internal.FriendlyByteBuf_, $$1: Internal.LevelChunk_): void;
        getBlockEntitiesTagsConsumer($$0: number, $$1: number): Internal.Consumer<Internal.ClientboundLevelChunkPacketData$BlockEntityTagOutput>;
        get heightmaps(): Internal.CompoundTag
        get readBuffer(): Internal.FriendlyByteBuf
    }
    type ClientboundLevelChunkPacketData_ = ClientboundLevelChunkPacketData;
    class SingletonArgumentInfo$Template implements Internal.ArgumentTypeInfo$Template<A> {
        constructor($$0: Internal.SingletonArgumentInfo_<any>, $$1: Internal.Function_<any, any>)
        type(): Internal.ArgumentTypeInfo<A, any>;
        instantiate($$0: Internal.CommandBuildContext_): A;
    }
    type SingletonArgumentInfo$Template_ = SingletonArgumentInfo$Template;
    class MinecraftProfileTexture$Type extends Internal.Enum<Internal.MinecraftProfileTexture$Type> {
        static values(): Internal.MinecraftProfileTexture$Type[];
        static valueOf(arg0: string): Internal.MinecraftProfileTexture$Type;
        static readonly CAPE: Internal.MinecraftProfileTexture$Type;
        static readonly ELYTRA: Internal.MinecraftProfileTexture$Type;
        static readonly SKIN: Internal.MinecraftProfileTexture$Type;
    }
    type MinecraftProfileTexture$Type_ = MinecraftProfileTexture$Type | "elytra" | "skin" | "cape";
    class NotSoMysteriousCubeBlock extends Internal.AEDecorativeBlock {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type NotSoMysteriousCubeBlock_ = NotSoMysteriousCubeBlock;
    class ServerboundContainerClickPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.ClickType_, $$5: Internal.ItemStack_, $$6: Internal.Int2ObjectMap_<Internal.ItemStack>)
        handle(arg0: Internal.PacketListener_): void;
        getButtonNum(): number;
        write($$0: Internal.FriendlyByteBuf_): void;
        getStateId(): number;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getChangedSlots(): Internal.Int2ObjectMap<Internal.ItemStack>;
        getCarriedItem(): Internal.ItemStack;
        getSlotNum(): number;
        getClickType(): Internal.ClickType;
        getContainerId(): number;
        isSkippable(): boolean;
        get buttonNum(): number
        get stateId(): number
        get changedSlots(): Internal.Int2ObjectMap<Internal.ItemStack>
        get carriedItem(): Internal.ItemStack
        get slotNum(): number
        get clickType(): Internal.ClickType
        get containerId(): number
        get skippable(): boolean
    }
    type ServerboundContainerClickPacket_ = ServerboundContainerClickPacket;
    class MaterialItem extends Internal.Item implements Internal.IMaterialItem {
        constructor(properties: Internal.Item$Properties_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getMaterial(stack: Internal.ItemStack_): Internal.MaterialVariantId;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        withMaterial(material: Internal.MaterialVariantId_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        canUseMaterial(mat: Internal.MaterialId_): boolean;
        setAttackSpeed(attackSpeed: number): void;
        withMaterialForDisplay(materialId: Internal.MaterialVariantId_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        fillItemCategory(items: Internal.FabricItemGroupEntries_): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static withMaterial(stack: Internal.ItemStack_, material: Internal.MaterialVariantId_): Internal.ItemStack;
        static getMaterialFromStack(stack: Internal.ItemStack_): Internal.MaterialVariantId;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        canUseMaterial(mat: Internal.IMaterial_): boolean;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type MaterialItem_ = MaterialItem;
    interface ScreenMouseEvents$BeforeMouseClick {
        abstract beforeMouseClick(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number): void;
        (arg0: Internal.Screen, arg1: number, arg2: number, arg3: number): void;
    }
    type ScreenMouseEvents$BeforeMouseClick_ = ScreenMouseEvents$BeforeMouseClick;
    interface RegistryEntryRemovedCallback <T> {
        abstract onEntryRemoved(arg0: number, arg1: ResourceLocation_, arg2: T): void;
        event<T>(registry: Internal.Registry_<T>): net.fabricmc.fabric.api.event.Event<Internal.RegistryEntryRemovedCallback<T>>;
        (arg0: number, arg1: ResourceLocation, arg2: T): void;
    }
    type RegistryEntryRemovedCallback_<T> = RegistryEntryRemovedCallback<T>;
    class TorchflowerCropBlock extends Internal.CropBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly AGE: Internal.IntegerProperty;
        static readonly MAX_AGE: 2;
    }
    type TorchflowerCropBlock_ = TorchflowerCropBlock;
    interface BlockSensitiveBufferBuilder {
        abstract endBlock(): void;
        abstract beginBlock(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
    }
    type BlockSensitiveBufferBuilder_ = BlockSensitiveBufferBuilder;
    class PotatoProjectileEntityHitAction$Type extends Internal.Enum<Internal.PotatoProjectileEntityHitAction$Type> {
        static values(): Internal.PotatoProjectileEntityHitAction$Type[];
        static valueOf(name: string): Internal.PotatoProjectileEntityHitAction$Type;
        static readonly ON_HIT: Internal.PotatoProjectileEntityHitAction$Type;
        static readonly PRE_HIT: Internal.PotatoProjectileEntityHitAction$Type;
    }
    type PotatoProjectileEntityHitAction$Type_ = "on_hit" | PotatoProjectileEntityHitAction$Type | "pre_hit";
    class ZoneOffset extends Internal.ZoneId implements Internal.TemporalAccessor, Internal.Comparable<Internal.ZoneOffset>, Internal.TemporalAdjuster, Internal.Serializable {
        static ofHoursMinutes(arg0: number, arg1: number): Internal.ZoneOffset;
        static ofTotalSeconds(arg0: number): Internal.ZoneOffset;
        compareTo(arg0: Internal.ZoneOffset_): number;
        adjustInto(arg0: Internal.Temporal_): Internal.Temporal;
        static ofHours(arg0: number): Internal.ZoneOffset;
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        static of(arg0: string): Internal.ZoneOffset;
        compareTo(arg0: any): number;
        static ofHoursMinutesSeconds(arg0: number, arg1: number, arg2: number): Internal.ZoneOffset;
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        get(arg0: Internal.TemporalField_): number;
        getLong(arg0: Internal.TemporalField_): number;
        static from(arg0: Internal.TemporalAccessor_): Internal.ZoneOffset;
        isSupported(arg0: Internal.TemporalField_): boolean;
        getTotalSeconds(): number;
        get totalSeconds(): number
        static readonly MIN: Internal.ZoneOffset;
        static readonly MAX: Internal.ZoneOffset;
        static readonly UTC: Internal.ZoneOffset;
    }
    type ZoneOffset_ = ZoneOffset;
    abstract class HolderSet$ListBacked <T> implements Internal.HolderSet<T> {
        constructor()
        iterator(): Internal.Iterator<Internal.Holder<T>>;
        abstract unwrap(): Internal.Either<Internal.TagKey<T>, Internal.List<Internal.Holder<T>>>;
        abstract unwrapKey(): Internal.Optional<Internal.TagKey<T>>;
        /**
         * @deprecated
        */
        static emptyNamed<T>($$0: Internal.HolderOwner_<T>, $$1: Internal.TagKey_<T>): Internal.HolderSet$Named<T>;
        get($$0: number): Internal.Holder<T>;
        spliterator(): Internal.Spliterator<Internal.Holder<T>>;
        stream(): Internal.Stream<Internal.Holder<T>>;
        canSerializeIn($$0: Internal.HolderOwner_<T>): boolean;
        size(): number;
        static direct<E, T>($$0: Internal.Function_<E, Internal.Holder<T>>, ...$$1: E[]): Internal.HolderSet$Direct<T>;
        abstract contains(arg0: Internal.Holder_<T>): boolean;
        static direct<T>(...$$0: Internal.Holder_<T>[]): Internal.HolderSet$Direct<T>;
        forEach(arg0: Internal.Consumer_<Internal.Holder<T>>): void;
        static direct<T>($$0: Internal.List_<Internal.Holder<T>>): Internal.HolderSet$Direct<T>;
        getRandomElement($$0: Internal.RandomSource_): Internal.Optional<Internal.Holder<T>>;
        static direct<E, T>($$0: Internal.Function_<E, Internal.Holder<T>>, $$1: Internal.List_<E>): Internal.HolderSet$Direct<T>;
    }
    type HolderSet$ListBacked_<T> = HolderSet$ListBacked<T>;
    class ContainerFillingRecipeSerializer <T extends Internal.ContainerFillingRecipe> extends Internal.LoggingRecipeSerializer<T> {
        constructor(factory: any_<T>)
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(recipeId: ResourceLocation_, json: Internal.JsonObject_): T;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
    }
    type ContainerFillingRecipeSerializer_<T extends Internal.ContainerFillingRecipe> = ContainerFillingRecipeSerializer<T>;
    class DropTargetContext implements Internal.Serializable {
        getDropTarget(): Internal.DropTarget;
        getComponent(): Internal.Component;
        dropComplete(arg0: boolean): void;
        get dropTarget(): Internal.DropTarget
        get component(): Internal.Component
    }
    type DropTargetContext_ = DropTargetContext;
    interface WeightedEntry {
        abstract getWeight(): Internal.Weight;
        wrap<T>($$0: T, $$1: number): Internal.WeightedEntry$Wrapper<T>;
        get weight(): Internal.Weight
        (): Internal.Weight_;
    }
    type WeightedEntry_ = WeightedEntry;
    class SpatialAnchorBlock extends Internal.AEBaseEntityBlock<any> {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly POWERED: Internal.BooleanProperty;
    }
    type SpatialAnchorBlock_ = SpatialAnchorBlock;
    class BackpackUpgradeRecipe$Serializer extends Internal.RecipeWrapperSerializer<Internal.ShapedRecipe, any> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
    }
    type BackpackUpgradeRecipe$Serializer_ = BackpackUpgradeRecipe$Serializer;
    class PipeProperty extends Internal.Enum<Internal.PipeProperty> implements Internal.StringRepresentable {
        static values(): Internal.PipeProperty[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        isInsert(): boolean;
        isNormal(): boolean;
        isNone(): boolean;
        isExtract(): boolean;
        static valueOf(name: string): Internal.PipeProperty;
        get serializedName(): string
        get insert(): boolean
        get normal(): boolean
        get none(): boolean
        get extract(): boolean
        static readonly NORMAL: Internal.PipeProperty;
        static readonly EXTRACT: Internal.PipeProperty;
        static readonly INSERT: Internal.PipeProperty;
        static readonly NONE: Internal.PipeProperty;
    }
    type PipeProperty_ = "normal" | "insert" | PipeProperty | "extract" | "none";
    abstract class MapCodec <A> extends Internal.CompressorHolder implements Internal.MapEncoder<A>, Internal.MapDecoder<A> {
        constructor()
        codec(): Internal.Codec<A>;
        forGetter<O>(arg0: Internal.Function_<O, A>): Internal.RecordCodecBuilder<O, A>;
        abstract decode<T>(arg0: Internal.DynamicOps_<T>, arg1: Internal.MapLike_<T>): Internal.DataResult<A>;
        orElseGet(arg0: Internal.Supplier_<A>): this;
        map<B>(arg0: Internal.Function_<A, B>): Internal.MapDecoder<B>;
        flatXmap<S>(arg0: Internal.Function_<A, Internal.DataResult<S>>, arg1: Internal.Function_<S, Internal.DataResult<A>>): Internal.MapCodec<S>;
        stable(): this;
        fieldOf(arg0: string): this;
        setPartial(arg0: Internal.Supplier_<A>): this;
        flatMap<B>(arg0: Internal.Function_<A, Internal.DataResult<B>>): Internal.MapDecoder<B>;
        xmap<S>(arg0: Internal.Function_<A, S>, arg1: Internal.Function_<S, A>): Internal.MapCodec<S>;
        orElse(arg0: Internal.Consumer_<string>, arg1: A): this;
        abstract encode<T>(arg0: A, arg1: Internal.DynamicOps_<T>, arg2: Internal.RecordBuilder_<T>): Internal.RecordBuilder<T>;
        compressedBuilder<T>(arg0: Internal.DynamicOps_<T>): Internal.RecordBuilder<T>;
        mapResult(arg0: Internal.MapCodec$ResultFunction_<A>): this;
        static makeCompressedBuilder<T>(arg0: Internal.DynamicOps_<T>, arg1: Internal.KeyCompressor_<T>): Internal.RecordBuilder<T>;
        static of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>): Internal.MapCodec<A>;
        compressedDecode<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<A>;
        orElseGet(arg0: Internal.Consumer_<string>, arg1: Internal.Supplier_<A>): this;
        static unit<A>(arg0: A): Internal.MapCodec<A>;
        deprecated(arg0: number): this;
        dependent<E>(arg0: Internal.MapCodec_<E>, arg1: Internal.Function_<A, com.mojang.datafixers.util.Pair<E, Internal.MapCodec<E>>>, arg2: Internal.BiFunction_<A, E, A>): this;
        withLifecycle(arg0: Internal.Lifecycle_): this;
        comap<B>(arg0: Internal.Function_<B, A>): Internal.MapEncoder<B>;
        encoder(): Internal.Encoder<A>;
        abstract keys<T>(arg0: Internal.DynamicOps_<T>): Internal.Stream<T>;
        decoder(): Internal.Decoder<A>;
        ap<E>(arg0: Internal.MapDecoder_<Internal.Function<A, E>>): Internal.MapDecoder<E>;
        static forStrings(arg0: Internal.Supplier_<Internal.Stream<string>>): Internal.Keyable;
        static of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>, arg2: Internal.Supplier_<string>): Internal.MapCodec<A>;
        abstract compressor<T>(arg0: Internal.DynamicOps_<T>): Internal.KeyCompressor<T>;
        flatComap<B>(arg0: Internal.Function_<B, Internal.DataResult<A>>): Internal.MapEncoder<B>;
        static unit<A>(arg0: Internal.Supplier_<A>): Internal.MapCodec<A>;
        orElse(arg0: A): this;
        orElse(arg0: Internal.UnaryOperator_<string>, arg1: A): this;
        orElseGet(arg0: Internal.UnaryOperator_<string>, arg1: Internal.Supplier_<A>): this;
        set partial(arg0: Internal.Supplier_<A>)
    }
    type MapCodec_<A> = MapCodec<A>;
    class SmallConnectorBlock extends Internal.AbstractConnectorBlock<Internal.SmallConnectorBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.SmallConnectorBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.SmallConnectorBlockEntity;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.SmallConnectorBlockEntity>): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.SmallConnectorBlockEntity>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        getBlockEntityClass(): typeof Internal.SmallConnectorBlockEntity;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntityType(): Internal.BlockEntityType<Internal.SmallConnectorBlockEntity>;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityClass(): typeof Internal.SmallConnectorBlockEntity
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.SmallConnectorBlockEntity>
        static readonly CONNECTOR_SHAPE: Internal.VoxelShaper;
    }
    type SmallConnectorBlock_ = SmallConnectorBlock;
    class Vec3Iota extends Internal.Iota {
        constructor(datum: Vec3d_)
        toleratesOther(that: Internal.Iota_): boolean;
        static display(v: Vec3d_): net.minecraft.network.chat.Component;
        static display(x: number, y: number, z: number): net.minecraft.network.chat.Component;
        getVec3(): Vec3d;
        static deserialize(tag: Internal.Tag_): Internal.Vec3Iota;
        get vec3(): Vec3d
        static TYPE: Internal.Vec3Iota$1;
    }
    type Vec3Iota_ = Vec3Iota;
    class DragonForgeRecipe implements Internal.Recipe<Internal.BlockEntityDragonForge> {
        constructor(recipeId: ResourceLocation_, input: Internal.Ingredient_, blood: Internal.Ingredient_, result: Internal.ItemStack_, dragonType: string, cookTime: number)
        matches(inv: Internal.BlockEntityDragonForge_, worldIn: Internal.Level_): boolean;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        getRemainingItems($$0: Internal.BlockEntityDragonForge_): Internal.NonNullList<Internal.ItemStack>;
        craft(dragonforge: Internal.BlockEntityDragonForge_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getBlood(): Internal.Ingredient;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getResultItem(): Internal.ItemStack;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        isValidBlood(blood: Internal.ItemStack_): boolean;
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getDragonType(): string;
        getType(): ResourceLocation;
        isValidInput(stack: Internal.ItemStack_): boolean;
        getInput(): Internal.Ingredient;
        setGroup(group: string): void;
        getCookTime(): number;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get blood(): Internal.Ingredient
        get resultItem(): Internal.ItemStack
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get dragonType(): string
        get type(): ResourceLocation
        get input(): Internal.Ingredient
        set group(group: string)
        get cookTime(): number
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type DragonForgeRecipe_ = DragonForgeRecipe;
    abstract class TrunkPlacer {
        constructor($$0: number, $$1: number, $$2: number)
        abstract placeTrunk(arg0: Internal.LevelSimulatedReader_, arg1: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg2: Internal.RandomSource_, arg3: number, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): Internal.List<Internal.FoliagePlacer$FoliageAttachment>;
        isFree($$0: Internal.LevelSimulatedReader_, $$1: BlockPos_): boolean;
        getTreeHeight($$0: Internal.RandomSource_): number;
        static readonly MAX_HEIGHT: 80;
        static readonly CODEC: Internal.Codec<Internal.TrunkPlacer>;
    }
    type TrunkPlacer_ = TrunkPlacer;
    interface IMaterialItem extends Internal.ItemLike {
        canUseMaterial(mat: Internal.IMaterial_): boolean;
        emi(amount: number): Internal.EmiStack;
        canUseMaterial(mat: Internal.MaterialId_): boolean;
        abstract getMaterial(arg0: Internal.ItemStack_): Internal.MaterialVariantId;
        abstract asItem(): Internal.Item;
        withMaterialForDisplay(materialId: Internal.MaterialVariantId_): Internal.ItemStack;
        emi(): Internal.EmiStack;
        withMaterial(stack: Internal.ItemStack_, material: Internal.MaterialVariantId_): Internal.ItemStack;
        withMaterial(material: Internal.MaterialVariantId_): Internal.ItemStack;
        getMaterialFromStack(stack: Internal.ItemStack_): Internal.MaterialVariantId;
    }
    type IMaterialItem_ = IMaterialItem;
    class BaseArmorItem extends Internal.ArmorItem implements Internal.ArmorTextureItem {
        constructor(armorMaterial: Internal.ArmorMaterial_, type: Internal.ArmorItem$Type_, properties: Internal.Item$Properties_, textureLoc: ResourceLocation_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        getArmorTexture(stack: Internal.ItemStack_, entity: Internal.Entity_, slot: Internal.EquipmentSlot_, type: string): string;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BaseArmorItem_ = BaseArmorItem;
    interface Double2CharFunction extends it.unimi.dsi.fastutil.Function<number, string>, Internal.DoubleToIntFunction {
        put(arg0: number, arg1: string): string;
        composeInt(arg0: Internal.Int2DoubleFunction_): Internal.Int2CharFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: string): string;
        composeDouble(arg0: Internal.Double2DoubleFunction_): this;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeLong(arg0: Internal.Long2DoubleFunction_): Internal.Long2CharFunction;
        andThenDouble(arg0: Internal.Char2DoubleFunction_): Internal.Double2DoubleFunction;
        composeByte(arg0: Internal.Byte2DoubleFunction_): Internal.Byte2CharFunction;
        defaultReturnValue(): string;
        andThenReference<T>(arg0: Internal.Char2ReferenceFunction_<T>): Internal.Double2ReferenceFunction<T>;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: string): string;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeFloat(arg0: Internal.Float2DoubleFunction_): Internal.Float2CharFunction;
        andThenByte(arg0: Internal.Char2ByteFunction_): Internal.Double2ByteFunction;
        defaultReturnValue(arg0: string): void;
        andThenChar(arg0: Internal.Char2CharFunction_): this;
        apply(arg0: number): string;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeChar(arg0: Internal.Char2DoubleFunction_): Internal.Char2CharFunction;
        andThenInt(arg0: Internal.Char2IntFunction_): Internal.Double2IntFunction;
        composeReference<T>(arg0: Internal.Reference2DoubleFunction_<T>): Internal.Reference2CharFunction<T>;
        andThenFloat(arg0: Internal.Char2FloatFunction_): Internal.Double2FloatFunction;
        andThenObject<T>(arg0: Internal.Char2ObjectFunction_<T>): Internal.Double2ObjectFunction<T>;
        containsKey(arg0: number): boolean;
        getOrDefault(arg0: number, arg1: string): string;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<string, T>): Internal.Function<number, T>;
        size(): number;
        andThenLong(arg0: Internal.Char2LongFunction_): Internal.Double2LongFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, string>;
        composeShort(arg0: Internal.Short2DoubleFunction_): Internal.Short2CharFunction;
        composeObject<T>(arg0: Internal.Object2DoubleFunction_<T>): Internal.Object2CharFunction<T>;
        clear(): void;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        andThenShort(arg0: Internal.Char2ShortFunction_): Internal.Double2ShortFunction;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        abstract get(arg0: number): string;
        remove(arg0: number): string;
        applyAsInt(arg0: number): number;
        (arg0: number): string;
    }
    type Double2CharFunction_ = Double2CharFunction;
    class FrogportBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.FrogportBlockEntity> {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.FrogportBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        getBlockEntityType(): Internal.BlockEntityType<Internal.FrogportBlockEntity>;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.FrogportBlockEntity>): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntityClass(): typeof Internal.FrogportBlockEntity;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.FrogportBlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.FrogportBlockEntity>;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityType(): Internal.BlockEntityType<Internal.FrogportBlockEntity>
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.FrogportBlockEntity
    }
    type FrogportBlock_ = FrogportBlock;
    class DoubleArgumentType implements Internal.ArgumentType<number> {
        getMaximum(): number;
        getExamples(): Internal.Collection<string>;
        getMinimum(): number;
        static doubleArg(): Internal.DoubleArgumentType;
        static doubleArg(arg0: number, arg1: number): Internal.DoubleArgumentType;
        static doubleArg(arg0: number): Internal.DoubleArgumentType;
        listSuggestions<S>(arg0: Internal.CommandContext_<S>, arg1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        static getDouble(arg0: Internal.CommandContext_<any>, arg1: string): number;
        parse(arg0: Internal.StringReader_): any;
        get maximum(): number
        get examples(): Internal.Collection<string>
        get minimum(): number
    }
    type DoubleArgumentType_ = DoubleArgumentType;
    interface IntSpliterator extends Internal.Spliterator$OfInt {
        /**
         * @deprecated
        */
        tryAdvance(arg0: Internal.Consumer_<number>): boolean;
        forEachRemaining(arg0: any): void;
        getComparator(): Internal.Comparator<any>;
        hasCharacteristics(arg0: number): boolean;
        forEachRemaining(arg0: it.unimi.dsi.fastutil.ints.IntConsumer_): void;
        forEachRemaining(arg0: Internal.IntConsumer_): void;
        skip(arg0: number): number;
        /**
         * @deprecated
        */
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        abstract estimateSize(): number;
        abstract tryAdvance(arg0: Internal.IntConsumer_): boolean;
        trySplit(): Internal.Spliterator<any>;
        getExactSizeIfKnown(): number;
        tryAdvance(arg0: any): boolean;
        abstract characteristics(): number;
        tryAdvance(arg0: it.unimi.dsi.fastutil.ints.IntConsumer_): boolean;
        get comparator(): Internal.Comparator<any>
        get exactSizeIfKnown(): number
    }
    type IntSpliterator_ = IntSpliterator;
    class KineticNetwork {
        constructor()
        add(be: Internal.KineticBlockEntity_): void;
        calculateCapacity(): number;
        updateCapacity(): void;
        addSilently(be: Internal.KineticBlockEntity_, lastCapacity: number, lastStress: number): void;
        remove(be: Internal.KineticBlockEntity_): void;
        updateNetwork(): void;
        initFromTE(maxStress: number, currentStress: number, members: number): void;
        updateStress(): void;
        calculateStress(): number;
        getSize(): number;
        getActualCapacityOf(be: Internal.KineticBlockEntity_): number;
        updateCapacityFor(be: Internal.KineticBlockEntity_, capacity: number): void;
        updateStressFor(be: Internal.KineticBlockEntity_, stress: number): void;
        getActualStressOf(be: Internal.KineticBlockEntity_): number;
        sync(): void;
        get size(): number
        sources: Internal.Map<Internal.KineticBlockEntity, number>;
        id: number;
        initialized: boolean;
        members: Internal.Map<Internal.KineticBlockEntity, number>;
    }
    type KineticNetwork_ = KineticNetwork;
    class ScrollInput extends Internal.AbstractSimiWidget {
        constructor(xIn: number, yIn: number, widthIn: number, heightIn: number)
        writingTo(label: Internal.Label_): this;
        charTyped($$0: string, $$1: number): boolean;
        static of(x: number, y: number, width: number, height: number): Internal.PositionedRectangle;
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        intersects(other: Internal.PositionedRectangle_): boolean;
        withShiftStep(step: number): this;
        withStepFunction(step: Internal.Function_<Internal.ScrollValueBehaviour$StepContext, number>): this;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        withRange(min: number, max: number): this;
        calling(onScroll: Internal.Consumer_<number>): this;
        titled(title: Internal.MutableComponent_): this;
        moveTo(x: number, y: number): void;
        setState(state: number): this;
        remove(): void;
        isInBoundingBox(x: number, y: number): boolean;
        hasParent(): boolean;
        fullSize(): Internal.Size;
        onChanged(): void;
        drawTooltip(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        getState(): number;
        mouseMoved($$0: number, $$1: number): void;
        tooltip(tooltip: Internal.Collection_<net.minecraft.network.chat.Component>): io.wispforest.owo.ui.core.Component;
        setPosition($$0: number, $$1: number): void;
        removeCallback(): this;
        sizing(sizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        standardStep(): Internal.Function<Internal.ScrollValueBehaviour$StepContext, number>;
        inverted(): this;
        format(formatter: Internal.Function_<number, net.minecraft.network.chat.Component>): this;
        drawFocusHighlight(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        sizing(horizontalSizing: Internal.Sizing_, verticalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        keyPressed($$0: number, $$1: number, $$2: number): boolean;
        static of(x: number, y: number, size: Internal.Size_): Internal.PositionedRectangle;
        addHint(hint: Internal.MutableComponent_): this;
        getCurrentFocusPath(): Internal.ComponentPath;
        intersection(other: Internal.PositionedRectangle_): Internal.PositionedRectangle;
        interpolate(next: Internal.PositionedRectangle_, delta: number): Internal.PositionedRectangle;
        root(): Internal.ParentComponent;
        tooltip(tooltip: net.minecraft.network.chat.Component_): io.wispforest.owo.ui.core.Component;
        set state(state: number)
        get state(): number
        get currentFocusPath(): Internal.ComponentPath
    }
    type ScrollInput_ = ScrollInput;
    abstract class FabricTagProvider <T> extends Internal.TagsProvider<T> {
        constructor(output: Internal.FabricDataOutput_, registryKey: Internal.ResourceKey_<Internal.Registry<T>>, registriesFuture: Internal.CompletableFuture_<Internal.HolderLookup$Provider>)
        static saveStable($$0: Internal.CachedOutput_, $$1: Internal.JsonElement_, $$2: Internal.Path_): Internal.CompletableFuture<any>;
    }
    type FabricTagProvider_<T> = FabricTagProvider<T>;
    interface EventExecutor extends Internal.EventExecutorGroup {
        abstract invokeAll<T>(arg0: Internal.Collection_<Internal.Callable<T>>, arg1: number, arg2: Internal.TimeUnit_): Internal.List<Internal.Future<T>>;
        abstract submit<T>(arg0: Internal.Runnable_, arg1: T): io.netty.util.concurrent.Future<T>;
        abstract newProgressivePromise<V>(): Internal.ProgressivePromise<V>;
        abstract scheduleAtFixedRate(arg0: Internal.Runnable_, arg1: number, arg2: number, arg3: Internal.TimeUnit_): io.netty.util.concurrent.ScheduledFuture<any>;
        spliterator(): Internal.Spliterator<Internal.EventExecutor>;
        abstract schedule<V>(arg0: Internal.Callable_<V>, arg1: number, arg2: Internal.TimeUnit_): io.netty.util.concurrent.ScheduledFuture<V>;
        abstract parent(): Internal.EventExecutorGroup;
        abstract next(): this;
        abstract newFailedFuture<V>(arg0: Internal.Throwable_): io.netty.util.concurrent.Future<V>;
        abstract isTerminated(): boolean;
        abstract invokeAny<T>(arg0: Internal.Collection_<Internal.Callable<T>>, arg1: number, arg2: Internal.TimeUnit_): T;
        abstract scheduleWithFixedDelay(arg0: Internal.Runnable_, arg1: number, arg2: number, arg3: Internal.TimeUnit_): io.netty.util.concurrent.ScheduledFuture<any>;
        abstract isShutdown(): boolean;
        abstract newPromise<V>(): Internal.Promise<V>;
        /**
         * @deprecated
        */
        abstract shutdownNow(): Internal.List<Internal.Runnable>;
        abstract invokeAll<T>(arg0: Internal.Collection_<Internal.Callable<T>>): Internal.List<Internal.Future<T>>;
        abstract shutdownGracefully(arg0: number, arg1: number, arg2: Internal.TimeUnit_): io.netty.util.concurrent.Future<any>;
        abstract shutdownGracefully(): io.netty.util.concurrent.Future<any>;
        abstract inEventLoop(arg0: Internal.Thread_): boolean;
        /**
         * @deprecated
        */
        abstract shutdown(): void;
        abstract terminationFuture(): io.netty.util.concurrent.Future<any>;
        abstract iterator(): Internal.Iterator<Internal.EventExecutor>;
        abstract awaitTermination(arg0: number, arg1: Internal.TimeUnit_): boolean;
        forEach(arg0: Internal.Consumer_<Internal.EventExecutor>): void;
        abstract schedule(arg0: Internal.Runnable_, arg1: number, arg2: Internal.TimeUnit_): io.netty.util.concurrent.ScheduledFuture<any>;
        close(): void;
        abstract invokeAny<T>(arg0: Internal.Collection_<Internal.Callable<T>>): T;
        abstract execute(arg0: Internal.Runnable_): void;
        abstract newSucceededFuture<V>(arg0: V): io.netty.util.concurrent.Future<V>;
        abstract submit(arg0: Internal.Runnable_): io.netty.util.concurrent.Future<any>;
        abstract submit<T>(arg0: Internal.Callable_<T>): io.netty.util.concurrent.Future<T>;
        abstract isShuttingDown(): boolean;
        abstract inEventLoop(): boolean;
        get terminated(): boolean
        get shutdown(): boolean
        get shuttingDown(): boolean
    }
    type EventExecutor_ = EventExecutor;
    abstract class WearableArtifactItem extends Internal.ArtifactItem {
        constructor()
        constructor(properties: Internal.Item$Properties_)
        static setActivated(stack: Internal.ItemStack_, active: boolean): void;
        toggleItem(player: Internal.ServerPlayer_): void;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static isActivated(stack: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        addAttributeModifier(attributeModifier: Internal.ArtifactAttributeModifier_): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        setAttackSpeed(attackSpeed: number): void;
        getEquipSound(): Internal.SoundEvent;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        canWalkOnPowderedSnow(): boolean;
        use(level: Internal.Level_, user: Internal.Player_, hand: Internal.InteractionHand_): Internal.InteractionResultHolder<any>;
        getCreativeTab(): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getAttributeModifiers(): Internal.List<Internal.ArtifactAttributeModifier>;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getFortuneLevel(): number;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        wornTick(entity: Internal.LivingEntity_, stack: Internal.ItemStack_): void;
        getLootingLevel(): number;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        makesPiglinsNeutral(): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        findAllEquippedBy(entity: Internal.LivingEntity_): Internal.Stream<Internal.ItemStack>;
        onEquip(entity: Internal.LivingEntity_, stack: Internal.ItemStack_): void;
        onUnequip(entity: Internal.LivingEntity_, stack: Internal.ItemStack_): void;
        emi(amount: number): Internal.EmiStack;
        isEquippedBy(entity: Internal.LivingEntity_): boolean;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get equipSound(): Internal.SoundEvent
        get creativeTab(): string
        get attributeModifiers(): Internal.List<Internal.ArtifactAttributeModifier>
        get fortuneLevel(): number
        set armorKnockbackResistance(knockbackResistance: number)
        get lootingLevel(): number
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type WearableArtifactItem_ = WearableArtifactItem;
    /**
     * @deprecated
    */
    interface FabricLootPool {
        abstract getEntries(): Internal.List<Internal.LootPoolEntryContainer>;
        asVanilla(): Internal.LootPool;
        abstract getRolls(): Internal.NumberProvider;
        abstract getFunctions(): Internal.List<Internal.LootItemFunction>;
        abstract getConditions(): Internal.List<Internal.LootItemCondition>;
        get entries(): Internal.List<Internal.LootPoolEntryContainer>
        get rolls(): Internal.NumberProvider
        get functions(): Internal.List<Internal.LootItemFunction>
        get conditions(): Internal.List<Internal.LootItemCondition>
    }
    type FabricLootPool_ = FabricLootPool;
    class VertexFormat$IndexType extends Internal.Enum<Internal.VertexFormat$IndexType> {
        static values(): Internal.VertexFormat$IndexType[];
        static valueOf($$0: string): Internal.VertexFormat$IndexType;
        static least($$0: number): Internal.VertexFormat$IndexType;
        static readonly SHORT: Internal.VertexFormat$IndexType;
        readonly asGLType: number;
        static readonly INT: Internal.VertexFormat$IndexType;
        readonly bytes: number;
    }
    type VertexFormat$IndexType_ = VertexFormat$IndexType | "int" | "short";
    class CaveSurface extends Internal.Enum<Internal.CaveSurface> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getY(): number;
        getSerializedName(): string;
        static values(): Internal.CaveSurface[];
        static valueOf($$0: string): Internal.CaveSurface;
        getDirection(): Internal.Direction;
        get y(): number
        get serializedName(): string
        get direction(): Internal.Direction
        static readonly FLOOR: Internal.CaveSurface;
        static readonly CEILING: Internal.CaveSurface;
        static readonly CODEC: Internal.Codec<Internal.CaveSurface>;
    }
    type CaveSurface_ = "floor" | CaveSurface | "ceiling";
    class ItemSeaSerpentArmor extends Internal.ArmorItem implements Internal.IArmorFinder {
        constructor(armorType: Internal.SeaSerpent_, material: Internal.CustomArmorMaterial_, slot: Internal.ArmorItem$Type_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        isEquipped(player: Internal.LivingEntity_, stack: Internal.ItemStack_): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        isEquipped(player: Internal.LivingEntity_, item: Internal.Item_): boolean;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        readonly armorType: Internal.SeaSerpent;
    }
    type ItemSeaSerpentArmor_ = ItemSeaSerpentArmor;
    class EntityType <T extends Internal.Entity> implements Internal.FeatureElement, Internal.DynamicLightHandlerHolder<any>, Internal.InjectedEntityTypeExtension, Internal.EntityTypeExtension<any>, Internal.EntityTypeTest<Internal.Entity, T> {
        constructor($$0: Internal.EntityType$EntityFactory_<T>, $$1: Internal.MobCategory_, $$2: boolean, $$3: boolean, $$4: boolean, $$5: boolean, $$6: Internal.ImmutableSet_<Internal.Block>, $$7: Internal.EntityDimensions_, $$8: number, $$9: number, $$10: Internal.FeatureFlagSet_)
        getBaseClass(): typeof Internal.Entity;
        create($$0: Internal.ServerLevel_, $$1: Internal.CompoundTag_, $$2: Internal.Consumer_<T>, $$3: BlockPos_, $$4: Internal.MobSpawnType_, $$5: boolean, $$6: boolean): T;
        arch$holder(): Internal.Holder<Internal.EntityType<any>>;
        toShortString(): string;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getWidth(): number;
        spawn($$0: Internal.ServerLevel_, $$1: Internal.ItemStack_, $$2: Internal.Player_, $$3: BlockPos_, $$4: Internal.MobSpawnType_, $$5: boolean, $$6: boolean): T;
        getAABB($$0: number, $$1: number, $$2: number): Internal.AABB;
        tryCast(arg0: any): any;
        lambdynlights$getName(): net.minecraft.network.chat.Component;
        lambdynlights$getSetting(): Internal.LightSourceSettingEntry;
        static appendCustomNameConfig<T extends Internal.Entity>($$0: Internal.Consumer_<T>, $$1: Internal.ItemStack_): Internal.Consumer<T>;
        getDescriptionId(): string;
        canSummon(): boolean;
        updateInterval(): number;
        static byString($$0: string): Internal.Optional<Internal.EntityType<any>>;
        getDimensions(): Internal.EntityDimensions;
        lambdynlights$getId(): ResourceLocation;
        static appendCustomEntityStackConfig<T extends Internal.Entity>($$0: Internal.Consumer_<T>, $$1: Internal.ServerLevel_, $$2: Internal.ItemStack_, $$3: Internal.Player_): Internal.Consumer<T>;
        static create($$0: Internal.CompoundTag_, $$1: Internal.Level_): Internal.Optional<Internal.Entity>;
        trackDeltas(): boolean;
        canSerialize(): boolean;
        flywheel$setVisualizer(visualizer: Internal.EntityVisualizer_<any>): void;
        static appendDefaultStackConfig<T extends Internal.Entity>($$0: Internal.Consumer_<T>, $$1: Internal.ServerLevel_, $$2: Internal.ItemStack_, $$3: Internal.Player_): Internal.Consumer<T>;
        static forClass<B, T extends B>($$0: T): Internal.EntityTypeTest<B, T>;
        static updateCustomEntityTag($$0: Internal.Level_, $$1: Internal.Player_, $$2: Internal.Entity_, $$3: Internal.CompoundTag_): void;
        getDescription(): net.minecraft.network.chat.Component;
        isBlockDangerous($$0: Internal.BlockState_): boolean;
        tryCast($$0: Internal.Entity_): T;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.EntityType<any>>;
        clientTrackingRange(): number;
        getCategory(): Internal.MobCategory;
        getDefaultLootTable(): ResourceLocation;
        static loadEntityRecursive($$0: Internal.CompoundTag_, $$1: Internal.Level_, $$2: Internal.Function_<Internal.Entity, Internal.Entity>): Internal.Entity;
        getHeight(): number;
        static createDefaultStackConfig<T extends Internal.Entity>($$0: Internal.ServerLevel_, $$1: Internal.ItemStack_, $$2: Internal.Player_): Internal.Consumer<T>;
        fireImmune(): boolean;
        arch$registryName(): ResourceLocation;
        flywheel$getVisualizer(): Internal.EntityVisualizer<any>;
        canSpawnFarFromPlayer(): boolean;
        static by($$0: Internal.CompoundTag_): Internal.Optional<Internal.EntityType<any>>;
        static getKey($$0: Internal.EntityType_<any>): ResourceLocation;
        create($$0: Internal.Level_): T;
        static cast<T extends Internal.Entity>(entityType: Internal.EntityType_<T>): Internal.DynamicLightHandlerHolder<T>;
        spawn($$0: Internal.ServerLevel_, $$1: Internal.CompoundTag_, $$2: Internal.Consumer_<T>, $$3: BlockPos_, $$4: Internal.MobSpawnType_, $$5: boolean, $$6: boolean): T;
        requiredFeatures(): Internal.FeatureFlagSet;
        is($$0: Internal.TagKey_<Internal.EntityType<any>>): boolean;
        static loadEntitiesRecursive($$0: Internal.List_<Internal.Tag>, $$1: Internal.Level_): Internal.Stream<Internal.Entity>;
        spawn($$0: Internal.ServerLevel_, $$1: BlockPos_, $$2: Internal.MobSpawnType_): T;
        get baseClass(): typeof Internal.Entity
        get width(): number
        get descriptionId(): string
        get dimensions(): Internal.EntityDimensions
        get description(): net.minecraft.network.chat.Component
        get category(): Internal.MobCategory
        get defaultLootTable(): ResourceLocation
        get height(): number
        static readonly TURTLE: Internal.EntityType<Internal.Turtle>;
        static readonly EVOKER: Internal.EntityType<Internal.Evoker>;
        static readonly INTERACTION: Internal.EntityType<Internal.Interaction>;
        static readonly SHULKER_BULLET: Internal.EntityType<Internal.ShulkerBullet>;
        static readonly ARROW: Internal.EntityType<Internal.Arrow>;
        static readonly DOLPHIN: Internal.EntityType<Internal.Dolphin>;
        static readonly PUFFERFISH: Internal.EntityType<Internal.Pufferfish>;
        static readonly HUSK: Internal.EntityType<Internal.Husk>;
        static readonly PANDA: Internal.EntityType<Internal.Panda>;
        static readonly ENDER_DRAGON: Internal.EntityType<Internal.EnderDragon>;
        static readonly PILLAGER: Internal.EntityType<Internal.Pillager>;
        static readonly GUARDIAN: Internal.EntityType<Internal.Guardian>;
        static readonly PIG: Internal.EntityType<Internal.Pig>;
        static readonly WITCH: Internal.EntityType<Internal.Witch>;
        static readonly FURNACE_MINECART: Internal.EntityType<Internal.MinecartFurnace>;
        static readonly ITEM_FRAME: Internal.EntityType<Internal.ItemFrame>;
        static readonly ITEM_DISPLAY: Internal.EntityType<Internal.Display$ItemDisplay>;
        static readonly AREA_EFFECT_CLOUD: Internal.EntityType<Internal.AreaEffectCloud>;
        static readonly STRAY: Internal.EntityType<Internal.Stray>;
        static readonly OCELOT: Internal.EntityType<Internal.Ocelot>;
        static readonly CAVE_SPIDER: Internal.EntityType<Internal.CaveSpider>;
        static readonly VINDICATOR: Internal.EntityType<Internal.Vindicator>;
        static readonly CHEST_MINECART: Internal.EntityType<Internal.MinecartChest>;
        static readonly TNT: Internal.EntityType<Internal.PrimedTnt>;
        static readonly WITHER: Internal.EntityType<Internal.WitherBoss>;
        static readonly ENDER_PEARL: Internal.EntityType<Internal.ThrownEnderpearl>;
        static readonly CHICKEN: Internal.EntityType<Internal.Chicken>;
        static readonly END_CRYSTAL: Internal.EntityType<Internal.EndCrystal>;
        static readonly ARMOR_STAND: Internal.EntityType<Internal.ArmorStand>;
        static readonly CHEST_BOAT: Internal.EntityType<Internal.ChestBoat>;
        static readonly PHANTOM: Internal.EntityType<Internal.Phantom>;
        static readonly FIREBALL: Internal.EntityType<Internal.LargeFireball>;
        static readonly SALMON: Internal.EntityType<Internal.Salmon>;
        static readonly WITHER_SKULL: Internal.EntityType<Internal.WitherSkull>;
        static readonly BAT: Internal.EntityType<Internal.Bat>;
        static readonly SMALL_FIREBALL: Internal.EntityType<Internal.SmallFireball>;
        static readonly PAINTING: Internal.EntityType<Internal.Painting>;
        static readonly WOLF: Internal.EntityType<Internal.Wolf>;
        static readonly GHAST: Internal.EntityType<Internal.Ghast>;
        static readonly MARKER: Internal.EntityType<Internal.Marker>;
        static readonly ZOGLIN: Internal.EntityType<Internal.Zoglin>;
        static readonly SHEEP: Internal.EntityType<Internal.Sheep>;
        static readonly ZOMBIE_VILLAGER: Internal.EntityType<Internal.ZombieVillager>;
        static readonly SPECTRAL_ARROW: Internal.EntityType<Internal.SpectralArrow>;
        static readonly ENTITY_TAG: "EntityTag";
        static readonly CREEPER: Internal.EntityType<Internal.Creeper>;
        static readonly SPIDER: Internal.EntityType<Internal.Spider>;
        static readonly LLAMA: Internal.EntityType<Internal.Llama>;
        static readonly SNIFFER: Internal.EntityType<Internal.Sniffer>;
        static readonly BLAZE: Internal.EntityType<Internal.Blaze>;
        static readonly TNT_MINECART: Internal.EntityType<Internal.MinecartTNT>;
        static readonly GLOW_SQUID: Internal.EntityType<Internal.GlowSquid>;
        static readonly FOX: Internal.EntityType<Internal.Fox>;
        static readonly SILVERFISH: Internal.EntityType<Internal.Silverfish>;
        static readonly SQUID: Internal.EntityType<Internal.Squid>;
        static readonly WITHER_SKELETON: Internal.EntityType<Internal.WitherSkeleton>;
        static readonly ZOMBIFIED_PIGLIN: Internal.EntityType<Internal.ZombifiedPiglin>;
        static readonly COD: Internal.EntityType<Internal.Cod>;
        static readonly SPAWNER_MINECART: Internal.EntityType<Internal.MinecartSpawner>;
        static readonly COMMAND_BLOCK_MINECART: Internal.EntityType<Internal.MinecartCommandBlock>;
        static readonly GLOW_ITEM_FRAME: Internal.EntityType<Internal.GlowItemFrame>;
        static readonly ZOMBIE_HORSE: Internal.EntityType<Internal.ZombieHorse>;
        static readonly TEXT_DISPLAY: Internal.EntityType<Internal.Display$TextDisplay>;
        static readonly STRIDER: Internal.EntityType<Internal.Strider>;
        static readonly SLIME: Internal.EntityType<Internal.Slime>;
        static readonly MULE: Internal.EntityType<Internal.Mule>;
        static readonly TRADER_LLAMA: Internal.EntityType<Internal.TraderLlama>;
        static readonly DROWNED: Internal.EntityType<Internal.Drowned>;
        static readonly EVOKER_FANGS: Internal.EntityType<Internal.EvokerFangs>;
        static readonly MINECART: Internal.EntityType<Internal.Minecart>;
        static readonly PIGLIN: Internal.EntityType<Internal.Piglin>;
        static readonly EXPERIENCE_ORB: Internal.EntityType<Internal.ExperienceOrb>;
        static readonly LLAMA_SPIT: Internal.EntityType<Internal.LlamaSpit>;
        static readonly ALLAY: Internal.EntityType<Internal.Allay>;
        static readonly TROPICAL_FISH: Internal.EntityType<Internal.TropicalFish>;
        static readonly IRON_GOLEM: Internal.EntityType<Internal.IronGolem>;
        static readonly VEX: Internal.EntityType<Internal.Vex>;
        static readonly EXPERIENCE_BOTTLE: Internal.EntityType<Internal.ThrownExperienceBottle>;
        static readonly WARDEN: Internal.EntityType<Internal.Warden>;
        static readonly ENDERMITE: Internal.EntityType<Internal.Endermite>;
        static readonly BOAT: Internal.EntityType<Internal.Boat>;
        static readonly EYE_OF_ENDER: Internal.EntityType<Internal.EyeOfEnder>;
        static readonly WANDERING_TRADER: Internal.EntityType<Internal.WanderingTrader>;
        static readonly SNOW_GOLEM: Internal.EntityType<Internal.SnowGolem>;
        static readonly SNOWBALL: Internal.EntityType<Internal.Snowball>;
        static readonly VILLAGER: Internal.EntityType<Internal.Villager>;
        static readonly FIREWORK_ROCKET: Internal.EntityType<Internal.FireworkRocketEntity>;
        static readonly TADPOLE: Internal.EntityType<Internal.Tadpole>;
        static readonly LEASH_KNOT: Internal.EntityType<Internal.LeashFenceKnotEntity>;
        static readonly RAVAGER: Internal.EntityType<Internal.Ravager>;
        static readonly MAGMA_CUBE: Internal.EntityType<Internal.MagmaCube>;
        static readonly ZOMBIE: Internal.EntityType<Internal.Zombie>;
        static readonly CAT: Internal.EntityType<Internal.Cat>;
        static readonly HOGLIN: Internal.EntityType<Internal.Hoglin>;
        static readonly CAMEL: Internal.EntityType<Internal.Camel>;
        static readonly GOAT: Internal.EntityType<Internal.Goat>;
        static readonly PARROT: Internal.EntityType<Internal.Parrot>;
        static readonly AXOLOTL: Internal.EntityType<Internal.Axolotl>;
        static readonly DRAGON_FIREBALL: Internal.EntityType<Internal.DragonFireball>;
        static readonly PIGLIN_BRUTE: Internal.EntityType<Internal.PiglinBrute>;
        static readonly POLAR_BEAR: Internal.EntityType<Internal.PolarBear>;
        static readonly ELDER_GUARDIAN: Internal.EntityType<Internal.ElderGuardian>;
        static readonly ENDERMAN: Internal.EntityType<Internal.EnderMan>;
        static readonly BEE: Internal.EntityType<Internal.Bee>;
        static readonly POTION: Internal.EntityType<Internal.ThrownPotion>;
        static readonly HOPPER_MINECART: Internal.EntityType<Internal.MinecartHopper>;
        static readonly SKELETON: Internal.EntityType<Internal.Skeleton>;
        static readonly FROG: Internal.EntityType<Internal.Frog>;
        static readonly PLAYER: Internal.EntityType<Internal.Player>;
        static readonly SHULKER: Internal.EntityType<Internal.Shulker>;
        static readonly GIANT: Internal.EntityType<Internal.Giant>;
        static readonly FISHING_BOBBER: Internal.EntityType<Internal.FishingHook>;
        static readonly FALLING_BLOCK: Internal.EntityType<Internal.FallingBlockEntity>;
        static readonly COW: Internal.EntityType<Internal.Cow>;
        static readonly BLOCK_DISPLAY: Internal.EntityType<Internal.Display$BlockDisplay>;
        static readonly TRIDENT: Internal.EntityType<Internal.ThrownTrident>;
        static readonly SKELETON_HORSE: Internal.EntityType<Internal.SkeletonHorse>;
        static readonly ITEM: Internal.EntityType<Internal.ItemEntity>;
        static readonly HORSE: Internal.EntityType<Internal.Horse>;
        static readonly ILLUSIONER: Internal.EntityType<Internal.Illusioner>;
        static readonly LIGHTNING_BOLT: Internal.EntityType<Internal.LightningBolt>;
        static readonly MOOSHROOM: Internal.EntityType<Internal.MushroomCow>;
        static readonly RABBIT: Internal.EntityType<Internal.Rabbit>;
        static readonly DONKEY: Internal.EntityType<Internal.Donkey>;
        static readonly EGG: Internal.EntityType<Internal.ThrownEgg>;
    }
    type EntityType_<T extends Internal.Entity> = Special.EntityType | EntityType<T>;
    class BlastingUpgradeItem extends Internal.UpgradeItemBase<Internal.CookingUpgradeWrapper$BlastingUpgradeWrapper> implements Internal.ICookingUpgradeItem {
        constructor(blastingUpgradeConfig: Internal.CookingUpgradeConfig_, upgradeTypeLimitConfig: any_)
        getCookingUpgradeConfig(): Internal.CookingUpgradeConfig;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getInventoryColumnsTaken(): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getType(): Internal.UpgradeType<Internal.CookingUpgradeWrapper$BlastingUpgradeWrapper>;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get cookingUpgradeConfig(): Internal.CookingUpgradeConfig
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get inventoryColumnsTaken(): number
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get type(): Internal.UpgradeType<Internal.CookingUpgradeWrapper$BlastingUpgradeWrapper>
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TYPE: Internal.UpgradeType<Internal.CookingUpgradeWrapper$BlastingUpgradeWrapper>;
    }
    type BlastingUpgradeItem_ = BlastingUpgradeItem;
    class TreeFertilizerItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type TreeFertilizerItem_ = TreeFertilizerItem;
    class Criterion {
        constructor($$0: Internal.CriterionTriggerInstance_)
        constructor()
        getTrigger(): Internal.CriterionTriggerInstance;
        serializeToJson(): Internal.JsonElement;
        static criterionFromNetwork($$0: Internal.FriendlyByteBuf_): Internal.Criterion;
        static criterionFromJson($$0: Internal.JsonObject_, $$1: Internal.DeserializationContext_): Internal.Criterion;
        static criteriaFromNetwork($$0: Internal.FriendlyByteBuf_): Internal.Map<string, Internal.Criterion>;
        static criteriaFromJson($$0: Internal.JsonObject_, $$1: Internal.DeserializationContext_): Internal.Map<string, Internal.Criterion>;
        serializeToNetwork($$0: Internal.FriendlyByteBuf_): void;
        static serializeToNetwork($$0: Internal.Map_<string, Internal.Criterion>, $$1: Internal.FriendlyByteBuf_): void;
        get trigger(): Internal.CriterionTriggerInstance
    }
    type Criterion_ = Criterion;
    class DebugCardItem extends Internal.AEBaseItem implements Internal.AEToolItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type DebugCardItem_ = DebugCardItem;
    class ClientboundLevelEventPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: BlockPos_, $$2: number, $$3: boolean)
        handle(arg0: Internal.PacketListener_): void;
        getPos(): BlockPos;
        write($$0: Internal.FriendlyByteBuf_): void;
        getType(): number;
        getData(): number;
        isGlobalEvent(): boolean;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get pos(): BlockPos
        get type(): number
        get data(): number
        get globalEvent(): boolean
        get skippable(): boolean
    }
    type ClientboundLevelEventPacket_ = ClientboundLevelEventPacket;
    abstract class Locale$IsoCountryCode extends Internal.Enum<Internal.Locale$IsoCountryCode> {
        static valueOf(arg0: string): Internal.Locale$IsoCountryCode;
        static values(): Internal.Locale$IsoCountryCode[];
        static readonly PART1_ALPHA2: Internal.Locale$IsoCountryCode;
        static readonly PART1_ALPHA3: Internal.Locale$IsoCountryCode;
        static readonly PART3: Internal.Locale$IsoCountryCode;
    }
    type Locale$IsoCountryCode_ = Locale$IsoCountryCode | "part1_alpha2" | "part3" | "part1_alpha3";
    interface KubeJSCraftingRecipe extends Internal.CraftingRecipe {
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        abstract matches(arg0: Internal.CraftingContainer_, arg1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        abstract kjs$getModifyResult(): Internal.ModifyRecipeResultCallback;
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        abstract assemble(arg0: Internal.CraftingContainer_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        abstract category(): Internal.CraftingBookCategory;
        kjs$getRemainingItems(container: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        abstract getId(): ResourceLocation;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        getMod(): string;
        abstract kjs$getIngredientActions(): Internal.List<Internal.IngredientAction>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        abstract getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        abstract kjs$getStage(): string;
        abstract canCraftInDimensions(arg0: number, arg1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        kjs$assemble(container: Internal.CraftingContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type KubeJSCraftingRecipe_ = KubeJSCraftingRecipe;
    class Navigation implements Internal.AccessorNavigation, Internal.IWaypointableNavigation, Internal.IBufferBlockCheckableNavigation, Internal.IGenerallySearchableNavigation {
        constructor(train: Internal.Train_)
        findPathTo(destinations: Internal.ArrayList_<Internal.GlobalStation>, maxCost: number): Internal.DiscoveredPath;
        controlSignalScout(): Internal.TravellingPoint$ITrackSelector;
        findNearestApproachable(forward: boolean): Internal.GlobalStation;
        railways$findNearestApproachableSwitch(forward: boolean): net.createmod.catnip.data.Pair<any, any>;
        read(tag: Internal.CompoundTag_, graph: Internal.TrackGraph_, dimensions: Internal.DimensionPalette_): void;
        tick(level: Internal.Level_): void;
        findPathTo(destination: Internal.GlobalStation_, maxCost: number): Internal.DiscoveredPath;
        isActive(): boolean;
        getCurrentPath(): Internal.List<any>;
        search(maxDistance: number, forward: boolean, destinations: Internal.ArrayList_<Internal.GlobalStation>, stationTest: Internal.Navigation$StationTest_): void;
        railways$updateControlsBlock(forceBackwards: boolean): void;
        write(dimensions: Internal.DimensionPalette_): Internal.CompoundTag;
        search(maxDistance: number, maxCost: number, forward: boolean, destinations: Internal.ArrayList_<Internal.GlobalStation>, stationTest: Internal.Navigation$StationTest_): void;
        railways$searchGeneral(maxDistance: number, maxCost: number, forward: boolean, pointTest: Internal.IGenerallySearchableNavigation$PointTest_): void;
        control(mp: Internal.TravellingPoint_): Internal.TravellingPoint$ITrackSelector;
        railways$isWaypointMode(): boolean;
        railways$searchGeneral(maxDistance: number, forward: boolean, pointTest: Internal.IGenerallySearchableNavigation$PointTest_): void;
        cancelNavigation(): void;
        startNavigation(pathTo: Internal.DiscoveredPath_): number;
        get active(): boolean
        get currentPath(): Internal.List<any>
        distanceStartedAt: number;
        announceArrival: boolean;
        destination: Internal.GlobalStation;
        destinationBehindTrain: boolean;
        distanceToDestination: number;
        distanceToSignal: number;
        waitingForSignal: net.createmod.catnip.data.Pair<Internal.UUID, boolean>;
        train: Internal.Train;
        ticksWaitingForSignal: number;
    }
    type Navigation_ = Navigation;
    interface SearchTree <T> {
        abstract search(arg0: string): Internal.List<T>;
        (arg0: string): Internal.List_<T>;
    }
    type SearchTree_<T> = SearchTree<T>;
    class ShovelItemBuilder extends Internal.HandheldItemBuilder {
        constructor(i: ResourceLocation_)
        createObject(): Internal.Item;
    }
    type ShovelItemBuilder_ = ShovelItemBuilder;
    interface ICustomOutputRecipe <C extends net.minecraft.world.Container> extends Internal.ICommonRecipe<C> {
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(access: Internal.RegistryAccess_): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        /**
         * @deprecated
        */
        assemble(inv: C, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        abstract matches(arg0: C, arg1: Internal.Level_): boolean;
        setGroup(group: string): void;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        abstract getId(): ResourceLocation;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        getRemainingItems($$0: C): Internal.NonNullList<Internal.ItemStack>;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type ICustomOutputRecipe_<C extends net.minecraft.world.Container> = ICustomOutputRecipe<C>;
    interface AccessorCarriageContraptionEntity {
        abstract railways$setCarriage(arg0: Internal.Carriage_): void;
        abstract railways$bindCarriage(): void;
    }
    type AccessorCarriageContraptionEntity_ = AccessorCarriageContraptionEntity;
    class ToolDefinitionData {
        canPerformAction(action: Internal.ToolAction_): boolean;
        write(buffer: Internal.FriendlyByteBuf_): void;
        buildStatMultipliers(builder: Internal.ModifierStatsBuilder_): void;
        getAOE(): Internal.IAreaOfEffectIterator;
        getStartingSlots(type: Internal.SlotType_): number;
        static read(buffer: Internal.FriendlyByteBuf_): Internal.ToolDefinitionData;
        getMultiplier(toolStat: Internal.INumericToolStat_<any>): number;
        getAttack(): Internal.IWeaponAttack;
        getHarvestLogic(): Internal.IHarvestLogic;
        getModule<T>(hook: Internal.ModifierHook_<T>): T;
        buildSlots(persistentModData: Internal.ModDataNBT_): void;
        getBaseStat<T>(toolStat: Internal.IToolStat_<T>): T;
        getModules(): Internal.ModifierHookMap;
        getAllBaseStats(): Internal.Set<Internal.IToolStat<any>>;
        hasBaseStat(stat: Internal.IToolStat_<any>): boolean;
        getTraits(): Internal.List<Internal.ModifierEntry>;
        getParts(): Internal.List<Internal.PartRequirement>;
        get AOE(): Internal.IAreaOfEffectIterator
        get attack(): Internal.IWeaponAttack
        get harvestLogic(): Internal.IHarvestLogic
        get modules(): Internal.ModifierHookMap
        get allBaseStats(): Internal.Set<Internal.IToolStat<any>>
        get traits(): Internal.List<Internal.ModifierEntry>
        get parts(): Internal.List<Internal.PartRequirement>
        static readonly EMPTY: Internal.ToolDefinitionData;
    }
    type ToolDefinitionData_ = ToolDefinitionData;
    class ChorusFlowerBlock extends Internal.Block {
        constructor($$0: Internal.ChorusPlantBlock_, $$1: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static generatePlant($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.RandomSource_, $$3: number): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly AGE: Internal.IntegerProperty;
        static readonly DEAD_AGE: 5;
    }
    type ChorusFlowerBlock_ = ChorusFlowerBlock;
    interface ISpatialStorageCell {
        abstract getMaxStoredDim(arg0: Internal.ItemStack_): number;
        abstract getAllocatedPlotId(arg0: Internal.ItemStack_): number;
        abstract isSpatialStorage(arg0: Internal.ItemStack_): boolean;
        abstract doSpatialTransition(arg0: Internal.ItemStack_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: BlockPos_, arg4: number): boolean;
    }
    type ISpatialStorageCell_ = ISpatialStorageCell;
    interface LithiumInternerWrapper <T> {
        abstract deleteCanonical(arg0: T): void;
        abstract getCanonical(arg0: T): T;
    }
    type LithiumInternerWrapper_<T> = LithiumInternerWrapper<T>;
    class PBRAtlasHolder {
        constructor()
        getNormalAtlas(): Internal.PBRAtlasTexture;
        setSpecularAtlas(atlas: Internal.PBRAtlasTexture_): void;
        setNormalAtlas(atlas: Internal.PBRAtlasTexture_): void;
        cycleAnimationFrames(): void;
        getSpecularAtlas(): Internal.PBRAtlasTexture;
        get normalAtlas(): Internal.PBRAtlasTexture
        set specularAtlas(atlas: Internal.PBRAtlasTexture_)
        set normalAtlas(atlas: Internal.PBRAtlasTexture_)
        get specularAtlas(): Internal.PBRAtlasTexture
    }
    type PBRAtlasHolder_ = PBRAtlasHolder;
    class EtrionicBlastFurnaceBlock extends Internal.MachineBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly BOTTOM_NORTH_SHAPE: Internal.ArrayVoxelShape;
        static readonly BOTTOM_EAST_SHAPE: Internal.ArrayVoxelShape;
        static readonly BOTTOM_SOUTH_SHAPE: Internal.ArrayVoxelShape;
        static readonly BOTTOM_WEST_SHAPE: Internal.ArrayVoxelShape;
    }
    type EtrionicBlastFurnaceBlock_ = EtrionicBlastFurnaceBlock;
    interface IBlockToolSwapUpgrade {
        abstract onBlockInteract(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): boolean;
        canProcessBlockInteract(): boolean;
        (arg0: Internal.Level, arg1: BlockPos, arg2: Internal.BlockState, arg3: Internal.Player): boolean;
    }
    type IBlockToolSwapUpgrade_ = IBlockToolSwapUpgrade;
    class AddOreProperties {
        constructor()
        /**
         * @deprecated
        */
        aboveBottom(y: number): Internal.VerticalAnchor;
        size(s: number): this;
        /**
         * @deprecated
        */
        bottom(): Internal.VerticalAnchor;
        /**
         * @deprecated
        */
        belowTop(y: number): Internal.VerticalAnchor;
        count(c: number): this;
        addTarget(ruleTest: Internal.RuleTest_, targetState: BlockStatePredicate_): void;
        squared(): this;
        triangleHeight(min: number, max: number): this;
        triangleHeight(absolute: Internal.VerticalAnchor_, absolute1: Internal.VerticalAnchor_): this;
        /**
         * @deprecated
        */
        top(): Internal.VerticalAnchor;
        count(c: Internal.IntProvider_): this;
        count(min: number, max: number): this;
        chance(c: number): this;
        uniformHeight(min: number, max: number): this;
        uniformHeight(absolute: Internal.VerticalAnchor_, absolute1: Internal.VerticalAnchor_): this;
        height: Internal.HeightRangePlacement;
        retrogen: number;
        count: Internal.IntProvider;
        worldgenLayer: Internal.GenerationStep$Decoration;
        chance: number;
        squared: boolean;
        noSurface: number;
        biomes: Internal.BiomeFilter;
        size: number;
        id: ResourceLocation;
        targets: Internal.List<Internal.OreConfiguration$TargetBlockState>;
    }
    type AddOreProperties_ = AddOreProperties;
    class ItemApiLookupImpl <A, C> implements Internal.ItemApiLookup<A, C> {
        registerSelf(...items: Internal.ItemLike_[]): void;
        getId(): ResourceLocation;
        contextClass(): C;
        find(itemStack: Internal.ItemStack_, context: C): A;
        getProvider(item: Internal.Item_): Internal.ItemApiLookup$ItemApiProvider<A, C>;
        apiClass(): A;
        registerFallback(fallbackProvider: Internal.ItemApiLookup$ItemApiProvider_<A, C>): void;
        static get<A, C>(lookupId: ResourceLocation_, apiClass: A, contextClass: C): Internal.ItemApiLookup<A, C>;
        registerForItems(provider: Internal.ItemApiLookup$ItemApiProvider_<A, C>, ...items: Internal.ItemLike_[]): void;
        get id(): ResourceLocation
    }
    type ItemApiLookupImpl_<A, C> = ItemApiLookupImpl<A, C>;
    class AENetworkBlockEntity extends Internal.AEBaseBlockEntity implements Internal.IGridConnectedBlockEntity {
        constructor(blockEntityType: Internal.BlockEntityType_<any>, pos: BlockPos_, blockState: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        static tryClear($$0: any): void;
        ifGridPresent(action: Internal.Consumer_<Internal.IGrid>): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        onChunkUnloaded(): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onMainNodeStateChanged(reason: Internal.IGridNodeListener$State_): void;
        onLoad(): void;
        getMainNode(): Internal.IManagedGridNode;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getGridNode(): Internal.IGridNode;
        getGridNode(dir: Internal.Direction_): Internal.IGridNode;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getCableConnectionType(dir: Internal.Direction_): Internal.AECableType;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getActionableNode(): Internal.IGridNode;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getGridConnectableSides(orientation: Internal.BlockOrientation_): Internal.Set<Internal.Direction>;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setOwner(owner: Internal.Player_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get displayName(): net.minecraft.network.chat.Component
        get mainNode(): Internal.IManagedGridNode
        get gridNode(): Internal.IGridNode
        get actionableNode(): Internal.IGridNode
        set owner(owner: Internal.Player_)
    }
    type AENetworkBlockEntity_ = AENetworkBlockEntity;
    interface LivingEntityExtensions {
        abstract artifacts$getPocketPistonLength(): number;
        (): number;
    }
    type LivingEntityExtensions_ = LivingEntityExtensions;
    class CartAssemblerBlock extends Internal.BaseRailBlock implements Internal.MinecartPassHandlerBlock, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.CartAssemblerBlockEntity>, Internal.SlopeCreationCheckingRailBlock, Internal.SpecialBlockItemRequirement {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getRequiredItems(state: Internal.BlockState_, be: Internal.BlockEntity_): Internal.ItemRequirement;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        onMinecartPass(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, cart: Internal.AbstractMinecart_): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        static getActionForCart(state: Internal.BlockState_, cart: Internal.AbstractMinecart_): Internal.CartAssemblerBlock$CartAssemblerAction;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        static canAssembleTo(cart: Internal.AbstractMinecart_): boolean;
        setLightEmission(v: number): void;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.CartAssemblerBlockEntity>;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CartAssemblerBlockEntity>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntityClass(): typeof Internal.CartAssemblerBlockEntity;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CartAssemblerBlockEntity;
        static getRailBlock(state: Internal.BlockState_): Internal.BlockState;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static getHorizontalDirection(blockState: Internal.BlockState_): Internal.Direction;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CartAssemblerBlockEntity>): void;
        getMod(): string;
        getDropsNoRail(state: Internal.BlockState_, world: Internal.ServerLevel_, pos: BlockPos_, p_220077_3_: Internal.BlockEntity_, p_220077_4_: Internal.Entity_, p_220077_5_: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CartAssemblerBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        canMakeSlopes(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_): boolean;
        static createAnchor(state: Internal.BlockState_): Internal.BlockState;
        emi(amount: number): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.CartAssemblerBlockEntity>
        get blockEntityClass(): typeof Internal.CartAssemblerBlockEntity
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly BACKWARDS: Internal.BooleanProperty;
        static readonly RAIL_TYPE: Internal.Property<Internal.CartAssembleRailType>;
        static readonly RAIL_SHAPE: Internal.Property<Internal.RailShape>;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type CartAssemblerBlock_ = CartAssemblerBlock;
    class EnderSlimeSlingItem extends Internal.BaseSlimeSlingItem {
        constructor(props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type EnderSlimeSlingItem_ = EnderSlimeSlingItem;
    class VarHandle$VarHandleDesc extends Internal.DynamicConstantDesc<Internal.VarHandle> {
        static ofArray(arg0: Internal.ClassDesc_): Internal.VarHandle$VarHandleDesc;
        resolveConstantDesc(arg0: Internal.MethodHandles$Lookup_): any;
        static ofField(arg0: Internal.ClassDesc_, arg1: string, arg2: Internal.ClassDesc_): Internal.VarHandle$VarHandleDesc;
        static ofStaticField(arg0: Internal.ClassDesc_, arg1: string, arg2: Internal.ClassDesc_): Internal.VarHandle$VarHandleDesc;
        varType(): Internal.ClassDesc;
    }
    type VarHandle$VarHandleDesc_ = VarHandle$VarHandleDesc;
    class CongealedSlimeBlock extends Internal.Block implements Internal.LandPathNodeTypesRegistry$StaticPathNodeTypeProvider {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getPathNodeType(state: Internal.BlockState_, neighbor: boolean): Internal.BlockPathTypes;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type CongealedSlimeBlock_ = CongealedSlimeBlock;
    class RedstoneFanBlock extends Internal.BaseFanBlock {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly ON: Internal.BooleanProperty;
    }
    type RedstoneFanBlock_ = RedstoneFanBlock;
    abstract class RenderLayer <T extends Internal.Entity, M extends Internal.EntityModel<T>> implements Internal.IUpperPartHelper {
        constructor($$0: any_<T, M>)
        isUpperPart(): boolean;
        abstract render(arg0: Internal.PoseStack_, arg1: Internal.MultiBufferSource_, arg2: number, arg3: T, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): void;
        setUpperPart(bl: boolean): void;
        getParentModel(): M;
        get upperPart(): boolean
        set upperPart(bl: boolean)
        get parentModel(): M
    }
    type RenderLayer_<T extends Internal.Entity, M extends Internal.EntityModel<T>> = RenderLayer<T, M>;
    class DataLayer {
        constructor()
        constructor($$0: number)
        constructor($$0: number[])
        getData(): number[];
        get($$0: number, $$1: number, $$2: number): number;
        copy(): this;
        isDefinitelyFilledWith($$0: number): boolean;
        layerToString($$0: number): string;
        fill($$0: number): void;
        set($$0: number, $$1: number, $$2: number, $$3: number): void;
        isEmpty(): boolean;
        isDefinitelyHomogenous(): boolean;
        get data(): number[]
        get empty(): boolean
        get definitelyHomogenous(): boolean
        static readonly LAYER_SIZE: 128;
        static readonly SIZE: 2048;
        static readonly LAYER_COUNT: 16;
    }
    type DataLayer_ = DataLayer;
    class CanyonCarverConfiguration extends Internal.CarverConfiguration {
        constructor($$0: number, $$1: Internal.HeightProvider_, $$2: Internal.FloatProvider_, $$3: Internal.VerticalAnchor_, $$4: Internal.CarverDebugSettings_, $$5: Internal.HolderSet_<Internal.Block>, $$6: Internal.FloatProvider_, $$7: Internal.CanyonCarverConfiguration$CanyonShapeConfiguration_)
        constructor($$0: Internal.CarverConfiguration_, $$1: Internal.FloatProvider_, $$2: Internal.CanyonCarverConfiguration$CanyonShapeConfiguration_)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.CanyonCarverConfiguration>;
        readonly shape: Internal.CanyonCarverConfiguration$CanyonShapeConfiguration;
        readonly verticalRotation: Internal.FloatProvider;
    }
    type CanyonCarverConfiguration_ = CanyonCarverConfiguration;
    interface FloatCollection extends Internal.FloatIterable, Internal.Collection<number> {
        abstract retainAll(arg0: Internal.FloatCollection_): boolean;
        abstract containsAll(arg0: Internal.FloatCollection_): boolean;
        abstract addAll(arg0: Internal.Collection_<number>): boolean;
        abstract addAll(arg0: Internal.FloatCollection_): boolean;
        abstract isEmpty(): boolean;
        removeIf(arg0: Internal.DoublePredicate_): boolean;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        abstract iterator(): Internal.FloatIterator;
        abstract contains(arg0: number): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        doubleParallelStream(): Internal.DoubleStream;
        doubleStream(): Internal.DoubleStream;
        /**
         * @deprecated
        */
        parallelStream(): Internal.Stream<number>;
        /**
         * @deprecated
        */
        contains(arg0: any): boolean;
        forEach(arg0: Internal.FloatConsumer_): void;
        abstract rem(arg0: number): boolean;
        abstract toArray(arg0: number[]): number[];
        abstract toArray<T>(arg0: T[]): T[];
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        doubleIterator(): Internal.DoubleIterator;
        abstract toArray(): any[];
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        /**
         * @deprecated
        */
        add(arg0: any): boolean;
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        abstract size(): number;
        abstract hashCode(): number;
        spliterator(): Internal.Spliterator<any>;
        doubleSpliterator(): Internal.DoubleSpliterator;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        abstract clear(): void;
        forEach(arg0: Internal.DoubleConsumer_): void;
        removeIf(arg0: Internal.FloatPredicate_): boolean;
        abstract add(arg0: number): boolean;
        /**
         * @deprecated
        */
        toFloatArray(arg0: number[]): number[];
        /**
         * @deprecated
        */
        add(arg0: number): boolean;
        /**
         * @deprecated
        */
        stream(): Internal.Stream<number>;
        abstract removeAll(arg0: Internal.FloatCollection_): boolean;
        abstract equals(arg0: any): boolean;
        abstract toFloatArray(): number[];
        get empty(): boolean
    }
    type FloatCollection_ = FloatCollection;
    interface MobEffectExtensions {
        getRenderer(): Internal.MobEffectRenderer;
        get renderer(): Internal.MobEffectRenderer
    }
    type MobEffectExtensions_ = MobEffectExtensions;
    class MilkFluid$Still extends Internal.MilkFluid {
        constructor()
        arch$holder(): Internal.Holder<Internal.Fluid>;
        getFluidDripWorldEvent(state: Internal.BlockState_, world: Internal.Level_, cauldronPos: BlockPos_): number;
        arch$registryName(): ResourceLocation;
    }
    type MilkFluid$Still_ = MilkFluid$Still;
    class IntegratedServer extends Internal.MinecraftServer {
        constructor($$0: Internal.Thread_, $$1: Internal.Minecraft_, $$2: Internal.LevelStorageSource$LevelStorageAccess_, $$3: Internal.PackRepository_, $$4: Internal.WorldStem_, $$5: Internal.Services_, $$6: any_)
        getDisplayName(): net.minecraft.network.chat.Component;
        getPlayer(selector: Internal.PlayerSelector_): Internal.ServerPlayer;
        self(): Internal.MinecraftServer;
        ask<Source>($$0: Internal.Function_<Internal.ProcessorHandle<Source>, Internal.TickTask>): Internal.CompletableFuture<Source>;
        schedule(timer: Internal.TemporalAmount_, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        getAdvancement(id: ResourceLocation_): Internal.AdvancementJS;
        scheduleRepeating(timer: Internal.TemporalAmount_, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        static of<Msg>($$0: string, $$1: Internal.Consumer_<Msg>): Internal.ProcessorHandle<Msg>;
        askEither<Source>($$0: Internal.Function_<Internal.ProcessorHandle<Internal.Either<Source, Internal.Exception>>, Internal.TickTask>): Internal.CompletableFuture<Source>;
        scheduleInTicks(ticks: number, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        getName(): net.minecraft.network.chat.Component;
        runCommandSilent(command: string): number;
        getEntities(): Internal.EntityArrayList;
        scheduleRepeatingInTicks(ticks: number, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        sendData(channel: string): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        sendData(channel: string, data: Internal.CompoundTag_): void;
        method_3823(): boolean;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getPlayers(): Internal.EntityArrayList;
        alwaysAccepts(): boolean;
        handler$hlm000$voicechat$publishServer(gameType: Internal.GameType_, cheats: boolean, port: number, callbackInfo: Internal.CallbackInfoReturnable_<any>): void;
        setUUID($$0: Internal.UUID_): void;
        runCommand(command: string): number;
        getLevel(dimension: ResourceLocation_): Internal.ServerLevel;
        get displayName(): net.minecraft.network.chat.Component
        get name(): net.minecraft.network.chat.Component
        get entities(): Internal.EntityArrayList
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get players(): Internal.EntityArrayList
        set UUID($$0: Internal.UUID_)
    }
    type IntegratedServer_ = IntegratedServer;
    interface LongUnaryOperator {
        andThen(arg0: Internal.LongUnaryOperator_): this;
        compose(arg0: Internal.LongUnaryOperator_): this;
        identity(): this;
        abstract applyAsLong(arg0: number): number;
        (arg0: number): number;
    }
    type LongUnaryOperator_ = LongUnaryOperator;
    class SmallDripleafBlock extends Internal.DoublePlantBlock implements Internal.SimpleWaterloggedBlock, Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.DirectionProperty;
    }
    type SmallDripleafBlock_ = SmallDripleafBlock;
    class DayOfWeek extends Internal.Enum<Internal.DayOfWeek> implements Internal.TemporalAccessor, Internal.TemporalAdjuster {
        minus(arg0: number): this;
        plus(arg0: number): this;
        static from(arg0: Internal.TemporalAccessor_): Internal.DayOfWeek;
        adjustInto(arg0: Internal.Temporal_): Internal.Temporal;
        static values(): Internal.DayOfWeek[];
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        getDisplayName(arg0: Internal.TextStyle_, arg1: Internal.Locale_): string;
        static of(arg0: number): Internal.DayOfWeek;
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        get(arg0: Internal.TemporalField_): number;
        getLong(arg0: Internal.TemporalField_): number;
        getValue(): number;
        static valueOf(arg0: string): Internal.DayOfWeek;
        isSupported(arg0: Internal.TemporalField_): boolean;
        get value(): number
        static readonly SUNDAY: Internal.DayOfWeek;
        static readonly SATURDAY: Internal.DayOfWeek;
        static readonly THURSDAY: Internal.DayOfWeek;
        static readonly FRIDAY: Internal.DayOfWeek;
        static readonly MONDAY: Internal.DayOfWeek;
        static readonly WEDNESDAY: Internal.DayOfWeek;
        static readonly TUESDAY: Internal.DayOfWeek;
    }
    type DayOfWeek_ = DayOfWeek | "tuesday" | "friday" | "thursday" | "monday" | "saturday" | "sunday" | "wednesday";
    interface ClientboundLevelChunkPacketData$BlockEntityTagOutput {
        abstract accept(arg0: BlockPos_, arg1: Internal.BlockEntityType_<any>, arg2: Internal.CompoundTag_): void;
        (arg0: BlockPos, arg1: Internal.BlockEntityType<any>, arg2: Internal.CompoundTag): void;
    }
    type ClientboundLevelChunkPacketData$BlockEntityTagOutput_ = ClientboundLevelChunkPacketData$BlockEntityTagOutput;
    class MaterialStatsId extends ResourceLocation {
        constructor(resourceLocation: ResourceLocation_)
        constructor(namespaceIn: string, pathIn: string)
        constructor(text: string)
        static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
    }
    type MaterialStatsId_ = MaterialStatsId;
    class ItemDragonSeeker extends Internal.Item {
        constructor(type: any_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemDragonSeeker_ = ItemDragonSeeker;
    interface FloatConsumer extends Internal.DoubleConsumer, Internal.Consumer<number> {
        /**
         * @deprecated
        */
        andThen(arg0: Internal.Consumer_<number>): Internal.Consumer<number>;
        andThen(arg0: Internal.FloatConsumer_): this;
        /**
         * @deprecated
        */
        accept(arg0: number): void;
        /**
         * @deprecated
        */
        accept(arg0: any): void;
        /**
         * @deprecated
        */
        accept(arg0: number): void;
        andThen(arg0: Internal.DoubleConsumer_): Internal.DoubleConsumer;
        abstract accept(arg0: number): void;
        (arg0: number): void;
    }
    type FloatConsumer_ = FloatConsumer;
    interface IDragonProof {
    }
    type IDragonProof_ = IDragonProof;
    class FireBlock extends Internal.BaseFireBlock implements Internal.FireBlockHooks {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        fabric_getVanillaEntry(block: Internal.BlockState_): Internal.FlammableBlockRegistry$Entry;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        setFlammable($$0: Internal.Block_, $$1: number, $$2: number): void;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        static bootStrap(): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly NORTH: Internal.BooleanProperty;
        static readonly AGE: Internal.IntegerProperty;
        static readonly SOUTH: Internal.BooleanProperty;
        static readonly UP: Internal.BooleanProperty;
        static readonly WEST: Internal.BooleanProperty;
        static readonly MAX_AGE: 15;
        static readonly EAST: Internal.BooleanProperty;
    }
    type FireBlock_ = FireBlock;
    interface ListIterator <E> extends Internal.Iterator<E> {
        abstract nextIndex(): number;
        abstract remove(): void;
        abstract hasPrevious(): boolean;
        forEachRemaining(arg0: Internal.Consumer_<E>): void;
        abstract next(): E;
        abstract previous(): E;
        abstract hasNext(): boolean;
        abstract add(arg0: E): void;
        abstract set(arg0: E): void;
        abstract previousIndex(): number;
    }
    type ListIterator_<E> = ListIterator<E>;
    class DepotMountedStorageType extends Internal.MountedItemStorageType<Internal.DepotMountedStorage> {
        constructor()
        mount(level: Internal.Level_, state: Internal.BlockState_, pos: BlockPos_, be: Internal.BlockEntity_): Internal.DepotMountedStorage;
    }
    type DepotMountedStorageType_ = DepotMountedStorageType;
    class ParticleKeyframeData extends Internal.KeyFrameData {
        constructor(startTick: number, effect: string, locator: string, script: string)
        getLocator(): string;
        script(): string;
        getEffect(): string;
        get locator(): string
        get effect(): string
    }
    type ParticleKeyframeData_ = ParticleKeyframeData;
    class ItemInterfaceUpgrade extends Internal.ItemUpgrade {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemInterfaceUpgrade_ = ItemInterfaceUpgrade;
    class ScreenDirection extends Internal.Enum<Internal.ScreenDirection> {
        isPositive(): boolean;
        isBefore($$0: number, $$1: number): boolean;
        static valueOf($$0: string): Internal.ScreenDirection;
        getOpposite(): this;
        getAxis(): Internal.ScreenAxis;
        static values(): Internal.ScreenDirection[];
        coordinateValueComparator(): Internal.IntComparator;
        isAfter($$0: number, $$1: number): boolean;
        get positive(): boolean
        get opposite(): Internal.ScreenDirection
        get axis(): Internal.ScreenAxis
        static readonly UP: Internal.ScreenDirection;
        static readonly RIGHT: Internal.ScreenDirection;
        static readonly LEFT: Internal.ScreenDirection;
        static readonly DOWN: Internal.ScreenDirection;
    }
    type ScreenDirection_ = ScreenDirection | "up" | "down" | "right" | "left";
    interface IStorageService extends Internal.IGridService {
        abstract getCachedInventory(): Internal.KeyCounter;
        abstract invalidateCache(): void;
        abstract refreshNodeStorageProvider(arg0: Internal.IGridNode_): void;
        abstract addGlobalStorageProvider(arg0: Internal.IStorageProvider_): void;
        abstract refreshGlobalStorageProvider(arg0: Internal.IStorageProvider_): void;
        abstract removeGlobalStorageProvider(arg0: Internal.IStorageProvider_): void;
        abstract getInventory(): Internal.MEStorage;
        get cachedInventory(): Internal.KeyCounter
        get inventory(): Internal.MEStorage
    }
    type IStorageService_ = IStorageService;
    class HoneyBottleItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type HoneyBottleItem_ = HoneyBottleItem;
    interface BooleanCollection extends Internal.BooleanIterable, Internal.Collection<boolean> {
        abstract addAll(arg0: Internal.BooleanCollection_): boolean;
        stream(): Internal.Stream<boolean>;
        /**
         * @deprecated
        */
        toBooleanArray(arg0: boolean[]): boolean[];
        abstract isEmpty(): boolean;
        abstract containsAll(arg0: Internal.BooleanCollection_): boolean;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<boolean>): void;
        abstract add(arg0: boolean): boolean;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        abstract addAll(arg0: Internal.Collection_<boolean>): boolean;
        removeIf(arg0: Internal.BooleanPredicate_): boolean;
        abstract retainAll(arg0: Internal.BooleanCollection_): boolean;
        parallelStream(): Internal.Stream<boolean>;
        /**
         * @deprecated
        */
        contains(arg0: any): boolean;
        abstract toBooleanArray(): boolean[];
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<boolean>): boolean;
        abstract toArray<T>(arg0: T[]): T[];
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        abstract toArray(): any[];
        /**
         * @deprecated
        */
        add(arg0: any): boolean;
        abstract iterator(): Internal.BooleanIterator;
        abstract size(): number;
        abstract hashCode(): number;
        spliterator(): Internal.Spliterator<any>;
        abstract removeAll(arg0: Internal.BooleanCollection_): boolean;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        /**
         * @deprecated
        */
        add(arg0: boolean): boolean;
        abstract contains(arg0: boolean): boolean;
        abstract clear(): void;
        abstract rem(arg0: boolean): boolean;
        abstract toArray(arg0: boolean[]): boolean[];
        abstract equals(arg0: any): boolean;
        forEach(arg0: it.unimi.dsi.fastutil.booleans.BooleanConsumer_): void;
        get empty(): boolean
    }
    type BooleanCollection_ = BooleanCollection;
}
declare namespace io.wispforest.owo.ui.core {
    class Insets extends Internal.Record implements Internal.Animatable<io.wispforest.owo.ui.core.Insets> {
        constructor(top: number, bottom: number, left: number, right: number)
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        vertical(): number;
        static vertical(inset: number): io.wispforest.owo.ui.core.Insets;
        withLeft(left: number): this;
        withTop(top: number): this;
        interpolate(next: io.wispforest.owo.ui.core.Insets_, delta: number): this;
        static of(top: number, bottom: number, left: number, right: number): io.wispforest.owo.ui.core.Insets;
        static top(top: number): io.wispforest.owo.ui.core.Insets;
        static horizontal(inset: number): io.wispforest.owo.ui.core.Insets;
        inverted(): this;
        withBottom(bottom: number): this;
        withRight(right: number): this;
        static right(right: number): io.wispforest.owo.ui.core.Insets;
        left(): number;
        bottom(): number;
        static none(): io.wispforest.owo.ui.core.Insets;
        static bottom(bottom: number): io.wispforest.owo.ui.core.Insets;
        add(top: number, bottom: number, left: number, right: number): this;
        static parse(insetsElement: Internal.Element_): io.wispforest.owo.ui.core.Insets;
        static both(horizontal: number, vertical: number): io.wispforest.owo.ui.core.Insets;
        horizontal(): number;
        top(): number;
        right(): number;
        static left(left: number): io.wispforest.owo.ui.core.Insets;
        static of(inset: number): io.wispforest.owo.ui.core.Insets;
    }
    type Insets_ = Insets;
}
declare namespace org.apache.commons.lang3.tuple {
    abstract class Pair <L, R> implements Internal.Map$Entry<L, R>, Internal.Comparable<org.apache.commons.lang3.tuple.Pair<L, R>>, Internal.Serializable {
        constructor()
        getKey(): L;
        static comparingByKey<K, V>(arg0: Internal.Comparator_<K>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        abstract getLeft(): L;
        static of<L, R>(arg0: L, arg1: R): org.apache.commons.lang3.tuple.Pair<L, R>;
        abstract getRight(): R;
        compareTo(arg0: org.apache.commons.lang3.tuple.Pair_<L, R>): number;
        static emptyArray<L, R>(): org.apache.commons.lang3.tuple.Pair<L, R>[];
        compareTo(arg0: any): number;
        getValue(): R;
        static comparingByValue<K, V extends Internal.Comparable<any>>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        static copyOf<K, V>(arg0: Internal.Map$Entry_<K, V>): Internal.Map$Entry<K, V>;
        static of<L, R>(arg0: Internal.Map$Entry_<L, R>): org.apache.commons.lang3.tuple.Pair<L, R>;
        static comparingByKey<K extends Internal.Comparable<any>, V>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        static comparingByValue<K, V>(arg0: Internal.Comparator_<V>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        abstract setValue(arg0: R): R;
        toString(arg0: string): string;
        get key(): L
        get left(): L
        get right(): R
        get value(): R
        set value(arg0: R)
        static readonly EMPTY_ARRAY: org.apache.commons.lang3.tuple.Pair<any, any>[];
    }
    type Pair_<L, R> = Pair<L, R>;
}
declare namespace gripe._90.polyeng.mixin {
    interface AbstractContainerScreenAccessor {
        abstract getImageHeight(): number;
        get imageHeight(): number
        (): number;
    }
    type AbstractContainerScreenAccessor_ = AbstractContainerScreenAccessor;
}
declare namespace me.lucko.spark.fabric.mixin {
    interface ServerEntityManagerAccessor {
        abstract getIndex(): Internal.EntityLookup<any>;
        abstract getCache(): Internal.EntitySectionStorage<Internal.Entity>;
        get index(): Internal.EntityLookup<any>
        get cache(): Internal.EntitySectionStorage<Internal.Entity>
    }
    type ServerEntityManagerAccessor_ = ServerEntityManagerAccessor;
}
declare namespace slimeknights.tconstruct.library.materials.definition {
    class Material implements Internal.IMaterial {
        constructor(identifier: ResourceLocation_, tier: number, order: number, craftable: boolean, hidden: boolean)
        getSortOrder(): number;
        getIdentifier(): Internal.MaterialId;
        matches(other: Internal.IMaterial_): boolean;
        getTier(): number;
        isHidden(): boolean;
        compareTo(other: Internal.IMaterial_): number;
        isCraftable(): boolean;
        compareTo(arg0: any): number;
        get sortOrder(): number
        get identifier(): Internal.MaterialId
        get tier(): number
        get hidden(): boolean
        get craftable(): boolean
    }
    type Material_ = Material;
}
